<?php

use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Config\Loader\LoaderInterface;

class AppKernel extends Kernel
{
    public $config_postfix = '';

    public $cache_dir = '/var/cache/';

    public $log_dir = '/var/logs';

    public function registerBundles()
    {
        $bundles = [
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new FOS\UserBundle\FOSUserBundle(),
            new Http\HttplugBundle\HttplugBundle(),
        	new HWI\Bundle\OAuthBundle\HWIOAuthBundle(),
            new MainBundle\MainBundle(),
            new Exercise\HTMLPurifierBundle\ExerciseHTMLPurifierBundle(),
            new \Aws\Symfony\AwsBundle(),
            new Translation\Bundle\TranslationBundle(),
            new Ekino\WordpressBundle\EkinoWordpressBundle(),
        ];

        if ($this->isDebug()) {
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Symfony\Bundle\MakerBundle\MakerBundle();
        }

        return $bundles;
    }

    public function getRootDir()
    {
        return __DIR__;
    }

    public function getCacheDir()
    {
        return dirname(__DIR__).$this->cache_dir.$this->getEnvironment();
    }

    public function getLogDir()
    {
        return dirname(__DIR__).$this->log_dir;
    }

    public function registerContainerConfiguration(LoaderInterface $loader)
    {
        $loader->load($this->getRootDir().'/config/config_'.$this->getEnvironment().$this->config_postfix.'.yml');
    }
}
