(function (global) {
    let gameCode = global.gameCode;
    let serverTime = global.serverTime;
    let storageKey = "demo-" + gameCode;
    let demoStart = global.localStorage.getItem(storageKey);
    let demoStartTime = 0;
    let localStartTime = Date.now();
    let timeLeft;
    let expireTime;
    let demoDurationInMinutes = 10;

    if(global.location.search.match(/[&?]debug=springbaystudio/)) {
        demoStart = null;
    }

    let getServerTime = function() {
        return serverTime + Math.round((Date.now() - localStartTime) / 1000);
    }

    let startDemo = function () {
        global.unityStarter && global.unityStarter();
        timeLeft = (demoStartTime + 60 * demoDurationInMinutes) - getServerTime();
        expireTime = Date.now() + timeLeft * 1000;
        update();
    }

    let twoDigits = function (num) {
        let str = "" + num;
        while (str.length < 2) {
            str = "0" + str;
        }
        return str;
    }

    let update = function () {
        timeLeft = expireTime - Date.now();
        let timerDisplay = '';
        if (timeLeft < 0) {
            // time is up
            console.log('Time is up');
            timerDisplay = '';
            $('#gameContainer').css('display', 'none');
            $('#gameContainer').remove();

            $('.demoUI.demoExpire').css('display', 'flex');
        } else {
            let secs = Math.round(timeLeft / 1000);
            let mins = Math.floor(secs / 60);
            secs -= mins * 60;
            timerDisplay = twoDigits(mins) + ":" + twoDigits(secs);
            requestAnimationFrame(update);
        }
        $('.demoUI .timer').text(timerDisplay);
    };

    let onEmailChanged = function () {
        refreshPlayButton();
    }

    let refreshPlayButton = function() {
        let email = $('.demoForm input.work-email-input').val();
        let name = $('.demoForm input.name-input').val();
        setPlayEnabled(validateEmail(email) && !!name);
    }

    let setPlayEnabled = function (enable) {
        $('.demoForm button.btn-start-play').prop('disabled', !enable);
    }
    setPlayEnabled(false);

    function validateEmail(email) {
        const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
    }
    let onButtonPlay = function () {
        let email = $('.demoForm input.work-email-input').val();
        let name = $('.demoForm input.name-input').val();
        if (validateEmail(email) && !!name) {
            $.get(global.registerEmailUrl + '?email=' + encodeURIComponent(email) + '&name=' + encodeURIComponent(name));
            $('.demoForm').css('display', 'none');

            demoStartTime = getServerTime();
            global.localStorage.setItem(storageKey, JSON.stringify({
                gameCode: gameCode,
                time: demoStartTime,
                email: email,
                name: name,
            }));
            startDemo();
        }
    }

    let showForm = function() {
        $('.demoUI.demoForm').css('display', 'flex');
        $('.demoUI.demoForm input.work-email-input').on('keyup paste', onEmailChanged)
        $('.demoUI.demoForm input.name-input').on('keyup paste', onEmailChanged)
        $('.demoUI.demoForm .btn-start-play').on('click', onButtonPlay)
    }


    //-------------
    if (demoStart) {
        let demoInfo = JSON.parse(demoStart);
        demoStartTime = demoInfo.time;
        startDemo();
    } else {
        showForm();
    }
})(window);