<?php
namespace MainBundle\ApiServices;

use MainBundle\Exception\ManagerException;
use MainBundle\Controller\BaseApiController;
use MainBundle\Entity\AccessToken;
use MainBundle\Entity\Client;
use MainBundle\Entity\User;
use MainBundle\EntityManager\ClientManager;
use MainBundle\EntityManager\UserManager;
use MainBundle\EntityManager\TransactionRecordManager;

class BaseService
{
	/**
	 * @var BaseApiController
	 */
    protected $controller;
    
    /**
	 * @var User
	 */
	protected $user = null;
	/**
	 * @var Client
	 */
    protected $client = null;
    
	private $clientManager = null;

	private $userManager = null;
		
	public function __construct(BaseApiController $controller)
	{
		$this->controller = $controller;
	}

	protected function getClientManager(): ClientManager {
		if(empty($this->clientManager)) {
			$this->clientManager = new ClientManager($this->controller);
		}
		return $this->clientManager;
	}
	protected function getUserManager(): UserManager
    {
        if(empty($this->userManager)) {
            $this->userManager = new UserManager($this->controller);
        }
        return $this->userManager;
	}

	public function getUser(): User
	{
		$this->designContract(!empty($this->user), 'Not signed in');
		return $this->user;
	}
	public function getClient(): Client
	{
		$this->designContract(!empty($this->client), 'Not signed in');
		return $this->client;
	}

	public function getClientByCode($clientCode): Client
	{
		return $this->getClientManager()->getByCode($clientCode);
	}
	public function getUserByUsername($username): User
	{
		return $this->getUserManager()->getByUsername($username);
	}

	public function setAccessToken(?Client $client, ?User $user)
	{
        $this->client = $client;
		$this->user = $user;
		$this->onAccessTokenSet();
	}

	protected function onAccessTokenSet()
	{
		
	}
	
	public function designContract($condition, $errorMessage)
	{
		if ($condition) {
			return;
		}

		throw new ManagerException($errorMessage);
	}
	
}