<?php
namespace MainBundle\ApiServices;

use MainBundle\ApiServices\Annotations\Validate;
use MainBundle\EntityManager\UserStateManager;
use MainBundle\Entity\User;
use MainBundle\Entity\Client;

class StateService extends BaseService
{
    /**
	 * @var UserStateManager
	 */
	private $_userStateManager = null;

    private function getUserStateManager(): UserStateManager
    {
        if($this->_userStateManager == null) {
            $this->_userStateManager = new UserStateManager($this->controller);
        }
        return $this->_userStateManager;
    }

	private function _getState(Client $client, User $user, $category, $key)
	{
		$state = $this->getUserStateManager()->getOneState($client, $user->getUsername(), $category, $key);
		return $state == null ? null : $state->exportShortJson();
	}
	private function _setState(Client $client, User $user, $category, $key, $value)
	{
		$state = $this->getUserStateManager()->setOneState($client, $user->getUsername(), $category, $key, $value);
		return $state->exportShortJson();
	}
	private function _removeState(Client $client, User $user, $category, $key)
	{
		return $this->getUserStateManager()->removeOneState($client, $user->getUsername(), $category, $key);
	}
	
	/**
	 * @Validate(secure=true)
	 */
	public function getState($args)
	{
		$category = $args['category'];
		$key = $args['key'];
		$user = $this->getUser();
		$client = $this->getClient();
		return ['userState' => $this->_getState($client, $user, $category, $key)];
	}
	
	/**
	 * @Validate(secure=true, register=true)
	 */
	public function setState($args)
	{
		$category = $args['category'];
		$key = $args['key'];
		$value = $args['value'];
        $user = $this->getUser();
		$client = $this->getClient();
		return ['userState' => $this->_setState($client, $user, $category, $key, $value)];
	}
	
	
	/**
	 * @Validate(secure=true, register=true)
	 */
	public function removeState($args)
	{
		$category = $args['category'];
		$key = $args['key'];
		$user = $this->getUser();
		$client = $this->getClient();
		return [$this->_removeState($client, $user, $category, $key)];
	}

	/**
	 * @Validate(secure=true)
	 */
	public function getStates($args)
	{
		$usernames = $args['usernames'];
		$categories = $args['categories'];
		$keys = $args['keys'];
		$client = $this->getClient();
		$states = $this->getUserStateManager()->getStates($client, $usernames, $categories, $keys);
		
		$list = array();
		/** @var $state \MainBundle\Entity\UserState */
		foreach($states as $state)
		{
			$list[] = $state->exportShortJson();
		}
		return [$list];
	}
	
	/**
	 * @Validate(secure=true, register=true)
	 */
	public function removeStates($args)
	{
		$usernames = $args['usernames'];
		$categories = $args['categories'];
		$keys = $args['keys'];
		$client = $this->getClient();
		return [$this->getUserStateManager()->removeStates($client, $usernames, $categories, $keys)];
	}
}