<?php

namespace MainBundle\ApiServices;

use MainBundle\Data\KidsUsername;
use MainBundle\ApiServices\Annotations\Validate;

class UserService extends BaseService
{
	
	public function getByUsername($args)
	{
		$username = $args['username'];
		$user = $this->getUserManager()->getByUsername($username);
		return ['user' => $this->controller->objToJson($user)];
    }
    
	public function listByUsernames($args)
	{
		$usernames = $args['usernames'];
		$users = $this->getUserManager()->listByUsernames($usernames);
		return ['list' => $this->controller->listToJson($users)];
	}

	public function getKidsUser($args)
	{
		$username = $args['username'];
		$user = $this->getUserManager()->getKidsUser($username);
		return ['user' => $user ? $this->controller->objToJson($user) : null];
	}

	/**
	 * @Validate(time=false,login=false)
	 */
	public function getMyUserOnWeb($args)
	{
		$this->getUserManager()->getWpService()->loadWordpress();
		$wpUser = \wp_get_current_user();
		if(empty($wpUser->ID)) {
			$user = $this->getUserManager()->getAnonymousUser();
		} else {
			$user = $this->getUserManager()->convertWpUserToUser($wpUser);
		}
        return [
			'user' => $this->controller->objToJson($user),
			'token' => $user->getAccessToken(),
		];
    }
	
	/**
	 * @Validate(secure=true)
	 */
	public function createKidsUser($args)
	{
		$username = $args['username'];
		$passcode = $args['passcode'];
		$email = $args['email'];
		$user = $this->getUserManager()->createKidsUser($username, $passcode, $email);
		return ['user' => $this->controller->objToJson($user), 'token' => $user->getAccessToken()];
	}
	
	/**
	 * @Validate(secure=true)
	 */
	public function validateKidsUser($args)
	{
		$username = $args['username'];
		$passcode = $args['passcode'];
		$user = $this->getUserManager()->validateKidsUser($username, $passcode);
		return ['user' => $this->controller->objToJson($user), 'token' => $user->getAccessToken()];
	}

	/**
	 * @Validate(secure=true)
	 */
	public function validateUsertoken($args)
	{
		$token = $args['token'];
		$params = explode('|', $token);
		$username = $params[0];
		$this->designContract(!empty($username), 'invalid token');
		$user = $this->getUserManager()->getByUsername($username);
		$this->designContract(!empty($user), 'invalid user token');
		$userToken = $user->getAccessToken();
		$this->designContract($userToken == $token, 'token expired');
		return ['user' => $this->controller->objToJson($user), 'token' => $user->getAccessToken()];
	}

	public function listKidsUsernamePrefix($args)
	{
		$list = KidsUsername::listPrefix();
		return ['list' => $list];
	}
	
	/**
	 * @Validate(secure=true)
	 */
	public function listSuggestedKidsUsernames($args)
	{
		$prefix = $args['prefix'];
		$postname = $args['postname'];
		$length = $args['length'];

		$list = array();
		$prefixList = null;
		$userManager = $this->getUserManager();
		if(empty($prefix)) {
			// if no specific prefix, we search for possible prefix first
			$prefixList = KidsUsername::listPrefix();
			shuffle($prefixList);
			while(!empty($prefixList) && count($list) < $length) {
				$pre = array_pop($prefixList);
				$username = $pre.$postname;
				if(empty($userManager->getKidsUser($username))) {
					$list[] = $username;
				}
			}
		}

		$triesToIncreaseMax = 5;
		$min = 0;
		$max = 10;
		while(count($list) < $length) {
			if(empty($prefixList)) {
				$prefixList = KidsUsername::listPrefix();
				shuffle($prefixList);
			}
			$pre = array_pop($prefixList);
			$username = $pre.$postname . rand($min, $max - 1);
			if(empty($userManager->getKidsUser($username))) {
				$list[] = $username;
			}

			if(--$triesToIncreaseMax < 0) {
				$triesToIncreaseMax = 10;
				$min = $max;
				$max *= 10;
			}
		}
		return ['list' => $list];
	}

}