<?php
namespace MainBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use MainBundle\Controller\IControllerBase;

class CommandBase extends ContainerAwareCommand implements IControllerBase
{
    public function getService($service)
    {
        if($service == 'aws.s3') {
            return $this->getContainer()->get('aws_service')->getS3Client();
        }
    	return $this->getContainer()->get($service);
    }

    protected function configure()
    {
        $this
            ->setName('academy:base')
            ->setDescription('not used')
        ;
    }
    
    /**
     * @return Controller
     */
    public function getThis()
    {
    	return $this;
    }
    
    public function isDev()
    {
        return $this->getYmlParameter('kernel.environment') == 'dev';
    }

    /**
     * 
     * {@inheritDoc}
     * @see \MainBundle\Controller\IControllerBase::getMyUser()
     */
    public function getMyUser()
    {
    	$userManager = new \MainBundle\EntityManager\UserManager($this);
        return $userManager->getByEmail('haskasu@gmail.com');
    }
    
    public function getYmlParameter($key)
    {
    	return $this->getContainer()->getParameter($key);
    }
    
    public function getObject($key)
    {
    	return $this->getContainer()->get($key);
    }

    public function purifyHTML($string)
    {
        $purifier = $this->getService('html_purifier_service')->purifier;
        return $purifier->purify($string);
    }

    public function objToJson($obj, $groups = null)
    {

    }
    public function listToJson($list, $groups = null)
    {

    }
}