<?php
namespace MainBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use MainBundle\EntityManager\ApplicationManager;
use MainBundle\EntityManager\SystemManager;
use MainBundle\Entity\System;

class UpdateCommand extends CommandBase
{
    protected function configure()
    {
        $this
            ->setName('academy:update')
            ->setDescription('Flush delayed push notifications.')
            ->addArgument('target', InputArgument::REQUIRED, 'The target content to be updated.')
            ->addOption('dry', null, InputOption::VALUE_NONE, 'If set, it will not actually push the notifications.')
        ;
    }
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $target = $input->getArgument('target');
        $dry = $input->getOption('dry');
        if($dry) {
            $output->writeln('** Dry run **');
        }

        $this->{'execute_'.$target}($input, $output, $dry);

    }

    private function execute_test(InputInterface $input, OutputInterface $output, $dry)
    {
        $output->writeln('** test command **');
    }

}