<?php

namespace MainBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

use MainBundle\EntityManager\ClassroomManager;
use MainBundle\EntityManager\UserLicenseManager;

class ApiClassroomController extends BaseApiController
{
    /**
     * @Route("/list/classrooms/{userToken}")
     */
    public function listCoursesByTeacher($userToken)
    {
        $manager = new ClassroomManager($this);
        $manager->initUserToken($userToken);
        return $this->createJsonRespons(array(
            'list' => $manager->listClassroomByOwner($manager->getUser()),
        ));
    }

    /**
     * @Route("/list/students/{courseId}/{userToken}")
     */
    public function listStudents($courseId, $userToken)
    {
        
        $manager = new ClassroomManager($this);
        $manager->initUserToken($userToken);
        return $this->createJsonRespons(array(
            'list' => $manager->listClassroomStudents($courseId),
        ));
    }

    /**
     * @Route("/list/classworks/{userToken}")
     */
    public function listClasswork($courseId, $userToken)
    {
        $manager = new ClassroomManager($this);
        $manager->initUserToken($userToken);
        $userLicenseManager = new UserLicenseManager($this);
        
        
        return $this->createJsonRespons(array(
            'list' => $manager->listClassroomStudents($courseId),
        ));
    }
}