<?php

namespace MainBundle\Controller;

use MainBundle\EntityManager\ClientManager;
use MainBundle\EntityManager\DemoEmailManager;
use MainBundle\EntityManager\UserLicenseManager;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;

class AppController extends ControllerBase
{

    /**
     * @Route("/app/{appName}", name="app")
     */
    public function appAction(Request $request, $appName)
    {
        $mobileDetect = new \MainBundle\Libs\MobileDetect\Mobile_Detect();
        $systemManager = new \MainBundle\EntityManager\SystemManager($this);
        $AmBox = $systemManager->generateIdeAmBox($appName, true);
        $muluUrl = $this->generateUrlWithUri('/mulu/' . $appName);
        $version = '';

        if($appName != 'co2-calculator') {

            $this->getWpServer()->loadWordpress();
            $clientManager = new ClientManager($this);
            $result = $clientManager->getAppLicenseWithPost($appName);
            if(empty($result)) {
                return $this->generateJsonResponse([
                    'status' => 'not licensed'
                ]);
            } else {
                $licensedPost = $result['post'];
                $license = $result['license'];
                $version = $clientManager->getAppVersionByPost($licensedPost);
                $licenseManager = new UserLicenseManager($this);
                $licenseManager->decreaseUserLicenseMaxaccess($license);
            }
        }

        try {

            return $this->render("@Main/App/$appName.html.twig", array(
                'appName' => $appName,
                'mobile' => $mobileDetect->isMobile() ? 'true' : 'false',
                'locale' => $this->getLocale($request),
                'AmBox' => base64_encode(json_encode($AmBox)),
                'muluUrl' => $muluUrl,
                'version' => $version,
                'demo' => false,
            ));
        } catch(\Exception $e) {
            return $this->redirect($this->generateUrlWithUri('/pagenotfound'));
        }
    }

    /**
     * @Route("/demo/{appName}", name="app_demo")
     */
    public function demoAction(Request $request, $appName)
    {
        $mobileDetect = new \MainBundle\Libs\MobileDetect\Mobile_Detect();
        $systemManager = new \MainBundle\EntityManager\SystemManager($this);
        $AmBox = $systemManager->generateIdeAmBox($appName, true);
        $muluUrl = $this->generateUrlWithUri('/mulu/' . $appName);
        $demoForm = null;
        $demoExpire = null;

        try {
            $this->getWpServer()->loadWordpress();
            $clientManager = new ClientManager($this);
            $version = $clientManager->getAppVersionByCode($appName);

            // $clientManager = new ClientManager($this);
            // $post = $clientManager->getAppPost($appName);

            // ob_start();
            // \the_content();
            // $postContent = ob_get_contents();
            // ob_clean();
            // $postContent = htmlspecialchars_decode($postContent);

            // $demoForm = null;
            // if(preg_match("/<!--demoForm start-->([\s\S]*)<!--demoForm end-->/", $postContent, $match)) {
            //     $demoForm = $match[0];
            // }
            // $demoExpire = null;
            // if(preg_match("/<!--demoForm start-->([\s\S]*)<!--demoExpire end-->/", $postContent, $match)) {
            //     $demoExpire = $match[0];
            // }

            return $this->render("@Main/App/$appName.html.twig", array(
                'appName' => $appName,
                'mobile' => $mobileDetect->isMobile() ? 'true' : 'false',
                'locale' => $this->getLocale($request),
                'AmBox' => base64_encode(json_encode($AmBox)),
                'muluUrl' => $muluUrl,
                'version' => $version,
                'demo' => true,
                'serverTime' => time(),
                'demoAppsUrl' => $this->generateUrlWithUri('/content-page/?demo'),
                'demoForm' => $demoForm,
                'demoExpire' => $demoExpire,
            ));
        } catch(\Exception $e) {
            //return $this->redirect($this->generateUrlWithUri('/pagenotfound'));
            return $this->generateJsonResponse([
                'error' => $e->getMessage(),
                'stack' => $e->getTraceAsString(),
            ]);
        }
    }

    /**
     * @Route("/register_demo_email", name="register_demo_email")
     */
    public function registerDemoEmail(Request $request)
    {
        $demoEmailManager = new DemoEmailManager($this);
        $demoEmailManager->registerEmail($request->get('email'), $request->get('name'), $request->get('source'), $request->get('receivable'));
        return $this->generateJsonResponse(['result' => 'done']);
    }

    /**
     * @Route("/app/{appName}/{token}", name="appWithToken", requirements={"token"=".+"})
     */
    public function appTokenAction(Request $request, $appName, $token)
    {
        return $this->appAction($request, $appName);
    }

    /**
     * @Route("/app_test/{appName}")
     */
    public function appTestAction(Request $request, $appName)
    {
        $mobileDetect = new \MainBundle\Libs\MobileDetect\Mobile_Detect();
        $systemManager = new \MainBundle\EntityManager\SystemManager($this);
        $AmBox = $systemManager->generateIdeAmBox($appName, true);
        return $this->generateJsonResponse(array(
            'appName' => $appName,
            'mobile' => $mobileDetect->isMobile() ? 'true' : 'false',
            'locale' => $this->getLocale($request),
            'AmBox' => $AmBox
        ));
    }

    /**
     * @Route("/user/{username}", name="user_index")
     */
    public function userIndexAction($username)
    {
        return $this->generateJsonResponse(array(
            'user' => $username
        ));
    }
    
}
