<?php

namespace MainBundle\Controller;

use MainBundle\Entity\User;
use Symfony\Component\HttpFoundation\JsonResponse;
use MainBundle\Exception\ManagerException;

class BaseApiController extends ControllerBase
{
    protected function createJsonRespons($json)
    {
        $response = new JsonResponse($json);
        //$response->headers->set('Access-Control-Allow-Origin', 'http://localhost:4200');
        return $response;
    }

    protected function getDocMgr(): \Doctrine\ORM\EntityManager
    {
        return $this->getService('doctrine')->getManager();
    }

    /**
     *
     * @throws \Exception
     * @return User
     */
    protected function getMe($throwExceptionIfNotLogin)
    {
        $user = $this->getMyUser();
        if ($user == null && $throwExceptionIfNotLogin) {
            throw new ManagerException('Please Login first.');
        }
        return $user;
    }

    protected function designContract($condition, $errorMessage)
	{
		if ($condition) {
			return;
		}
		throw new ManagerException($errorMessage);
	}

}