<?php

namespace MainBundle\Controller;

use MainBundle\Utils\FileUtil;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Console\Output\BufferedOutput;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class DefaultController extends ControllerBase
{

    private $admin_keyword = 'jjjgoesup1';

    /**
     *
     * @Route("/connect/{service}", name="springbayOauthConnect")
     */
    public function redirectToServiceAction(Request $request, $service)
    {

        /** @var \HWI\Bundle\OAuthBundle\Controller\RedirectToServiceController $controller */
        $controller = $this->getService('HWI\Bundle\OAuthBundle\Controller\RedirectToServiceController');

        if ($request->get('scope') == 'teacher') {
            $oauthUtils = $controller->getOauthUtils();
            $resourceOwner = $oauthUtils->getResourceOwner($service);
            $resourceOwner->setOption(
                'scope',
                $resourceOwner->getOption('scope')
                    . ' ' . \Google_Service_Classroom::CLASSROOM_COURSEWORK_STUDENTS
                    . ' ' . \Google_Service_Classroom::CLASSROOM_ROSTERS_READONLY
            );
        }
        return $controller->redirectToServiceAction($request, $service);
    }

    /**
     *
     * @Route("/login/{service}")
     */
    public function loginServiceAction(Request $request, $service)
    {
        $scope = $request->get('scope');
        $url = $this->generateUrl('springbayOauthConnect', ['service' => $service]);
        if(!empty($scope)) {
            $url .= "?scope=$scope";
        }
        $response = $this->redirect($url);
        $this->get('security.token_storage')->setToken(null);
		$this->get('session')->invalidate();
        $response->headers->clearCookie( 'REMEMBERME' );
        return $response;
    }


    /**
     *
     * @Route("/login_callback", name="login_callback")
     */
    public function loginCallbackAction()
    {
        $this->getWpServer()->loadWordpress();
        $wpUser = \wp_get_current_user();

        $userManager = new \MainBundle\EntityManager\UserManager($this);
        if (empty($wpUser)) {
            $user = null;
        } else {
            $user = $userManager->convertWpUserToUser($wpUser);
        }
        return $this->render('MainBundle:Security:login_popup_feedback.html.twig', [
            'user' => empty($user) ? null : $this->objToJson($user),
            'token' => empty($user) ? null : $user->getAccessToken(),
        ]);
    }
    /**
     *
     * @Route("/login_callback_test", name="login_callback_test", host="localhost")
     */
    public function loginCallbackTestAction()
    {
        return $this->render('MainBundle:Security:login_popup_feedback.test.twig');
    }

    /**
     *
     * @Route("/phpinfo/{password}", name="phpinfo")
     */
    public function phpinfoAction($password)
    {
        if ($password == $this->admin_keyword) {
            phpinfo();
            $result = 'good';
        } else {
            $result = 'wrong url';
        }
        return $this->generateJsonResponse($result);
    }

    /**
     * @Route("/clear_cache/{password}", name="clear_cache")
     */
    public function clearCacheAction($password)
    {
        if ($password == $this->admin_keyword) {
            $cacheDir = __DIR__ . '/../../../var/cache';
            $newDir = __DIR__ . '/../../../var/cache' . '_' . time();
            echo 'time: ' . time() . "<br/>\n";
            echo 'dir to clear: ' . realpath($cacheDir) . "<br/>\n";


            if (is_dir($cacheDir)) {
                $warmupUrl = $this->generateUrl('warmup', array('password' => $password));

                $result = rename($cacheDir, $newDir);
                @mkdir($cacheDir, 0777, true);
                FileUtil::deleteDirectory($newDir);
                $realPath = realpath($newDir);
                echo 'cache cleared => <a href="' . $warmupUrl . '">warmup</a>';
            }

            $cacheWarmer = $this->getService('html_purifier_service')->serializer->warmUp('');

            $result = array(
                'cacheDir' => $cacheDir,
                'newDir' => $newDir,
                'result' => $result,
            );
        } else {
            $result = 'wrong url';
        }

        return $this->generateJsonResponse($result);
    }

    /**
     * @Route("/warmup/{password}", name="warmup")
     */
    public function warmupAction(Request $request, $password)
    {
        if ($password == $this->admin_keyword) {
            $cacheWarmer = $this->getService('html_purifier_service')->serializer->warmUp('');
            echo 'warmup done';
            $result = array(
                'result' => $cacheWarmer,
            );
        } else {
            $result = 'wrong url';
        }

        return $this->generateJsonResponse($result);
    }

    /**
     * @Route("/update_database_tables/{password}", name="update_database_tables")
     */
    public function updateDatabaseTablesAction($password)
    {
        if ($password == $this->admin_keyword) {
            $kernel = $this->get('kernel');
            $application = new \Symfony\Bundle\FrameworkBundle\Console\Application($kernel);
            $application->setAutoExit(false);
            $output = new BufferedOutput();

            $options = array('command' => 'doctrine:schema:update', "--dump-sql" => true);
            $application->run(new \Symfony\Component\Console\Input\ArrayInput($options), $output);
            echo $output->fetch();
            echo "\n<br/>";
            $result = "done";
        } else {
            $result = 'wrong url';
        }
        return $this->generateJsonResponse($result);
    }

    /**
     *
     * @Route("/session/invalidate", name="invalidate_sessions")
     */
    public function invalidateSessionAction(Request $request)
    {
        $result = 'ok';
        session_destroy();

        return $this->generateJsonResponse(array(
            'result' => $result
        ));
    }

    /**
     *
     * @Route("/static/{folder}/v{ver}/{filename}", name="static_file")
     */
    public function staticFileAction($folder, $ver, $filename)
    {
        $folder = str_replace(['/', "\\"], ['', ''], $folder);
        $filename = str_replace(['/', "\\"], ['', ''], $filename);
        $fullpath = $this->getRootDir() . "/../content/$folder/$filename";
        if (file_exists(($fullpath))) {
            $response = new BinaryFileResponse($fullpath);
            $this->setMimeType($fullpath, $response);
            if(!$this->isDev()) {
                $response->setMaxAge(31536000);
                $response->setSharedMaxAge(31536000);
            }
        } else {
            $response = new Response('file does not exist ' . $fullpath);
        }
        return $response;
    }

    /**
     *
     * @Route("/static/{folder}/{filename}/v{ver}", name="static_file2")
     */
    public function staticFile2Action($folder, $filename, $ver)
    {
        $folder = str_replace(['/', "\\"], ['', ''], $folder);
        $filename = str_replace(['/', "\\"], ['', ''], $filename);
        $fullpath = $this->getRootDir() . "/../content/$folder/$filename";
        if (file_exists(($fullpath))) {
            $response = new BinaryFileResponse($fullpath);
            $this->setMimeType($fullpath, $response);
            if(!$this->isDev()) {
                $response->setMaxAge(31536000);
                $response->setSharedMaxAge(31536000);
            }
        } else {
            $response = new Response('file does not exist ' . $fullpath);
        }
        return $response;
    }

    private function setMimeType($file, Response $response)
    {
        $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        if ($ext == 'ipa') {
            $response->headers->set('Content-Type', 'application/iphone-package-archive');
        } else {
            $guesser = \Symfony\Component\Mime\MimeTypes::getDefault();
            $types = $guesser->getMimeTypes($ext);
            if (!empty($types)) {
                $response->headers->set('Content-Type', $types[0]);
            } else if (!empty($mimeType = $guesser->guessMimeType($file))) {
                $response->headers->set('Content-Type', $mimeType);
            }
        }
    }
}
