<?php
namespace MainBundle\Controller;

use MainBundle\Entity\User;

interface IControllerBase
{
	public function getService($service);

	/**
	 * @return Controller
	*/
	public function getThis();
	
	/**
	 * @return User
	 */
	public function getMyUser();

	/**
	 * 
	 * @param string $key
	 * @return mixed
	 */
	public function getYmlParameter($key);
	
	/**
	 *
	 * @param string $key
	 * @return mixed
	 */
	public function getObject($key);

	/**
	 * purify html using htmlPurifier
	 * @see https://github.com/Exercise/HTMLPurifierBundle
	 *
	 * @param string $string
	 * @return string
	 */
	public function purifyHTML($string);

	/**
	 * @return boolean
	 */
	public function isDev();

	public function objToJson($obj, $groups = null);
	public function listToJson($list, $groups = null);
}