<?php
namespace MainBundle\Controller;

use FOS\UserBundle\Controller\SecurityController as BaseController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use MainBundle\EntityManager\UserManager;

/**
 * {@inheritDoc}
 */
class SecurityController extends BaseController implements IControllerBase
{
	public function getService($service)
    {
		if($service == 'aws.s3') {
            return $this->get('aws_service')->getS3Client();
        }
    	return $this->get($service);
	}

	public function isDev()
    {
        return $this->container->getParameter('kernel.environment') == 'dev';
    }
	
	public function purifyHTML($string)
    {
        $purifier = $this->container->get('html_purifier_service')->purifier;
        return $purifier->purify($string);
    }
    
    public function getMyUser()
    {
    	if($this->isDev())
    	{
    		$userManager = new UserManager($this);
    		$user = $userManager->getByEmail('haskasu@gmail.com');
    		return $user;
    	}
    	return $this->getUser();
    }
    
    public function getYmlParameter($key)
    {
    	return $this->getParameter($key);
    }
    
    public function getObject($key)
    {
    	return $this->get($key);
    }
    
    /**
     * @return Controller
     */
    public function getThis()
    {
    	return $this;
    }

    /**
	 * {@inheritDoc}
	 */
	public function renderLogin(array $data)
	{
		$request = $this->container->get('request');
		$isPopup = $request->get('popup') == '1';

		if($isPopup)
		{
			if($this->getUser() != null)
			{
				return $this->redirect("/logout?popup=1");
			}

			return $this->render('MainBundle:Security:login_popup.html.twig', $data);
			//return $this->render('FOSUserBundle:Security:login_popup.html.twig', $data);
		}
		
		return parent::renderLogin($data);
    }
	
	
	public function loginFeedbackAction(Request $request)
	{
		$gameCode = $request->get("gameCode");
		
		return $this->render('FOSUserBundle:Security:loginGame_feedback.html.twig', array(
				'gameCode' => $gameCode,
				'background' => $this->getBackgroundUrl($gameCode)
		));
	}
	
	private function getBackgroundUrl($gameCode)
	{
		return "/img/login/$gameCode.jpg";
	}
	
	public function loggedOutAction()
	{
		return new JsonResponse("Logged out!");
	}

	public function objToJson($obj, $groups = null)
    {
        if($obj === null) {
            return null;
        }
        if(empty($groups)) {
            $groups = array('basic', 'full');
        }
        return $this->getSerializer()->normalize($obj, null, array('groups' => $groups));
    }
    public function listToJson($list, $groups = null)
    {
        if(empty($groups)) {
            $groups = array('basic');
        }

        $json = array();
        foreach ($list as $obj) {
            $json[] = $this->objToJson($obj, $groups);
        }
        return $json;
    }

}