<?php

namespace MainBundle\Data;

use MainBundle\Utils\StringUtil;

class KidsUsername
{
    static function generateUsername($username)
    {
        $username = StringUtil::removeEnd($username, '@kids');
        $username = preg_replace('/\s+/', '_', $username);
        return preg_replace('/[^a-zA-Z0-9._-]/', '', $username) . '@kids';
    }
    static function generateEmail($username)
    {
        $username = KidsUsername::generateUsername($username);
        return $username . '.sprintbaystudio.com';
    }
    static function generateNickname($username)
    {
        $username = StringUtil::removeEnd($username, '@kids');
        return preg_replace('/_/', ' ', $username);
    }
    static function listPrefix()
    {
        return array(
            'IAlgae',
            'Copepod',
            'BShrimp',
            'ArcCod',
            'Capelin',
            'BSeal',
            'Beluga',
            'BWhale',
            'EDuck',
            'Narwhal',
            'Orca',
            'PBear',
            'RSeal',
            'TMurre',
            'Walrus',
            'AFox',
            'Caribou',
            'Wolf',
            'AHare',
            'SOwl',
            'Lynx',
            'Bison',
            'BBeetle',
            'Krill',
            'Penguin',
            'LSeal',
            'KSeal',
        );
    }
}
