<?php
namespace MainBundle\Data;

class LocaleInfo
{

    static $ALL = null;

    public static function listAll()
    {
        if (self::$ALL == null) {
            self::$ALL = array(
                new LocaleInfo('en', 'English'),
                new LocaleInfo('fr', 'France'),
            );
        }
        return self::$ALL;
    }
    public static function getByCode($code)
    {
        foreach (self::listAll() as $locale) {
            if ($locale->code == $code) {
                return $locale;
            }
        }
        return self::listAll()[0];
    }

    public static function getDefault()
    {
        return LocaleInfo::listAll()[0];
    }

    public $code;

    public $name;

    public $fb_locale = 'en_US';

    public function __construct($code, $name)
    {
        $this->code = $code;
        $this->name = $name;
        if ($this->code == 'zh-Hant') {
            $this->fb_locale = 'zh_TW';
        }
    }
}
