<?php

namespace MainBundle\Entity\Abstracts;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

abstract class 
AbstractUserScore
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="periodStart", type="date")
     */
    protected $periodStart;

    /**
     * @ORM\ManyToOne(targetEntity="MainBundle\Entity\ScoreMode")
     * @ORM\JoinColumn(name="scoremode_id", referencedColumnName="id")
     */
    protected $scoreMode;

    /**
     * @var integer
     *
     * @ORM\Column(name="score", type="float")
     */
    protected $score;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="time", type="datetimetz")
     */
    protected $time;

    /**
     * @ORM\ManyToOne(targetEntity="MainBundle\Entity\User", inversedBy="userScores")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    public function exportJson()
    {
        $json = $this->exportJsonShort();
        $json['user'] = $this->user->exportJsonShort();
        return $json;
    }

    public function exportJsonShort()
    {
        return array(
            'score' => $this->score,
            'time' => $this->time->getTimestamp()
        );
    }
    public function exportJsonWithScoreMode()
    {
        return array(
            'score' => $this->score,
            'time' => $this->time->getTimestamp(),
            'scoreMode' => $this->scoreMode->exportJson()
        );
    }

    /**
     *
     * @return boolean
     */
    public function isHistory()
    {
        return false;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set score
     *
     * @param integer $score
     *
     * @return AbstractUserScore
     */
    public function setScore($score)
    {
        $this->score = $score;

        return $this;
    }

    /**
     * Get score
     *
     * @Groups({"basic"})
     * @return integer
     */
    public function getScore()
    {
        return $this->score;
    }

    /**
     * Set user
     *
     * @param \MainBundle\Entity\User $user
     *
     * @return AbstractUserScore
     */
    public function setUser(\MainBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @Groups({"full"})
     * @return \MainBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set time
     *
     * @param \DateTime $time
     *
     * @return AbstractUserScore
     */
    public function setTime($time)
    {
        $this->time = $time;

        return $this;
    }

    /**
     * Get time
     *
     * @Groups({"basic"})
     * @return \DateTime
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * Set periodStart
     *
     * @param \DateTime $time
     *
     * @return AbstractUserScore
     */
    public function setPeriodStart($periodStart)
    {
        $this->periodStart = $periodStart;

        return $this;
    }

    /**
     * Get periodStart
     *
     * @return \DateTime
     */
    public function getPeriodStart()
    {
        return $this->periodStart;
    }

    /**
     * Set scoreMode.
     *
     * @param \MainBundle\Entity\ScoreMode|null $scoreMode
     *
     * @return AbstractUserScore
     */
    public function setScoreMode(\MainBundle\Entity\ScoreMode $scoreMode = null)
    {
        $this->scoreMode = $scoreMode;

        return $this;
    }

    /**
     * Get scoreMode.
     *
     * @Groups({"basic"})
     * @return \MainBundle\Entity\ScoreMode|null
     */
    public function getScoreMode()
    {
        return $this->scoreMode;
    }
}
