<?php

namespace MainBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Symfony\Component\Serializer\Annotation\Groups;
use Doctrine\ORM\Mapping as ORM;
use \MainBundle\Entity\User;

/**
 * @ORM\Table(uniqueConstraints={@ORM\UniqueConstraint(name="service_code", columns={"service", "code"})})
 * @ORM\Entity
 */
class Classroom
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=127)
     */
    private $code;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="classrooms")
     * @ORM\JoinColumn(nullable=false)
     */
    private $owner;

    /**
     * @ORM\Column(type="datetime")
     */
    private $createTime;

    /**
     * @ORM\Column(type="string", length=15)
     */
    private $service;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="text")
     */
    private $originJson;

    /**
     * @ORM\OneToMany(targetEntity=Classwork::class, mappedBy="classroom")
     */
    private $classworks;

    public function __construct()
    {
        $this->classworks = new ArrayCollection();
    }

    /**
     * @Groups({"basic"})
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @Groups({"basic"})
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @Groups({"basic"})
     */
    public function getOwner(): ?User
    {
        return $this->owner;
    }

    public function setOwner(?User $owner): self
    {
        $this->owner = $owner;

        return $this;
    }

    /**
     * @Groups({"basic"})
     */
    public function getCreateTime(): ?\DateTimeInterface
    {
        return $this->createTime;
    }

    public function setCreateTime(\DateTimeInterface $createTime): self
    {
        $this->createTime = $createTime;

        return $this;
    }

    /**
     * @Groups({"basic"})
     */
    public function getService(): ?string
    {
        return $this->service;
    }

    public function setService(string $service): self
    {
        $this->service = $service;

        return $this;
    }

    /**
     * @Groups({"basic"})
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getOriginJson(): ?string
    {
        return $this->originJson;
    }

    public function setOriginJson(string $originJson): self
    {
        $this->originJson = $originJson;

        return $this;
    }

    /**
     * @return Collection|Classwork[]
     */
    public function getClassworks(): Collection
    {
        return $this->classworks;
    }

    public function addClasswork(Classwork $classwork): self
    {
        if (!$this->classworks->contains($classwork)) {
            $this->classworks[] = $classwork;
            $classwork->setClassroom($this);
        }

        return $this;
    }

    public function removeClasswork(Classwork $classwork): self
    {
        if ($this->classworks->contains($classwork)) {
            $this->classworks->removeElement($classwork);
            // set the owning side to null (unless already changed)
            if ($classwork->getClassroom() === $this) {
                $classwork->setClassroom(null);
            }
        }

        return $this;
    }
}
