<?php

namespace MainBundle\Entity;

use Symfony\Component\Serializer\Annotation\Groups;
use Doctrine\ORM\Mapping as ORM;

/**
 * Client
 *
 * @ORM\Table(name="client")
 * @ORM\Entity
 */
class Client {

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(type="string", length=63, unique=true)
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(type="string", length=63)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="MainBundle\Entity\ScoreMode", mappedBy="client")
     */
    private $scoreModes;

    public function exportJson()
    {
        return array(
            'code' => $this->code
        );
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scoreModes = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set code.
     *
     * @param string $code
     *
     * @return Client
     * @Groups({"basic"})
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }


    /**
     * Add scoreMode.
     *
     * @param \MainBundle\Entity\ScoreMode $scoreMode
     *
     * @return Client
     */
    public function addScoreMode(\MainBundle\Entity\ScoreMode $scoreMode)
    {
        $this->scoreModes[] = $scoreMode;

        return $this;
    }

    /**
     * Remove scoreMode.
     *
     * @param \MainBundle\Entity\ScoreMode $scoreMode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeScoreMode(\MainBundle\Entity\ScoreMode $scoreMode)
    {
        return $this->scoreModes->removeElement($scoreMode);
    }

    /**
     * Get scoreModes.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScoreModes()
    {
        return $this->scoreModes;
    }


    /**
     * Set name.
     *
     * @param string $name
     *
     * @return Client
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

}
