<?php

namespace MainBundle\Entity;

use MainBundle\Repository\DemoEmailRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity()
 */
class DemoEmail
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=127)
     */
    private $name = '';

    /**
     * @ORM\Column(type="string", length=255, unique=true)
     */
    private $email;

    /**
     * @ORM\Column(type="datetime")
     */
    private $createTime;

    /**
     * json: array of source strings
     * @ORM\Column(type="string", length=255)
     */
    private $sources = '';

    /**
     * @ORM\Column(type="integer")
     */
    private $count = 0;

    /**
     * @ORM\Column(type="boolean")
     */
    private $receivable = false;

    /**
     * @ORM\Column(type="datetime")
     */
    private $modifyTime;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getCreateTime(): ?\DateTimeInterface
    {
        return $this->createTime;
    }

    public function setCreateTime(\DateTimeInterface $createTime): self
    {
        $this->createTime = $createTime;

        return $this;
    }

    public function getCount(): ?int
    {
        return $this->count;
    }

    public function setCount(int $count): self
    {
        $this->count = $count;

        return $this;
    }

    public function getModifyTime(): ?\DateTimeInterface
    {
        return $this->modifyTime;
    }

    public function setModifyTime(\DateTimeInterface $modifyTime): self
    {
        $this->modifyTime = $modifyTime;

        return $this;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return DemoEmail
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set sources.
     *
     * @param string $sources
     *
     * @return DemoEmail
     */
    public function setSources($sources)
    {
        $this->sources = $sources;

        return $this;
    }

    /**
     * Get sources.
     *
     * @return string
     */
    public function getSources()
    {
        return $this->sources;
    }

    /**
     * Set receivable.
     *
     * @param bool $receivable
     *
     * @return DemoEmail
     */
    public function setReceivable($receivable)
    {
        $this->receivable = $receivable;

        return $this;
    }

    /**
     * Get receivable.
     *
     * @return bool
     */
    public function getReceivable()
    {
        return $this->receivable;
    }
}
