<?php

namespace MainBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use MainBundle\Data\OrderType;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ORM\Table(uniqueConstraints={@ORM\UniqueConstraint(name="client_mode", columns={"client_id", "score_key"})})
 * @ORM\Entity
 */
class ScoreMode
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=63)
     */
    private $name;

    /**
     * @ORM\Column(name="score_key", type="string", length=255)
     */
    private $scoreKey;

    /**
     * @ORM\Column(type="smallint")
     */
    private $showLength = 0;

    /**
     * @ORM\Column(type="datetime")
     */
    private $createTime;

    /**
     * @ORM\Column(type="boolean")
     */
    private $disabled = false;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $deleteTime;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $defaultTime;

    /**
     * @ORM\Column(type="integer")
     */
    private $toDollarRate = 0;

    /**
     * @ORM\Column(type="smallint")
     */
    private $orderType = OrderType::HIGH_TO_LOW;

    /**
     * @ORM\ManyToOne(targetEntity="MainBundle\Entity\Client", inversedBy="scoreModes")
     * @ORM\JoinColumn(name="client_id", referencedColumnName="id")
     */
    private $client;

    public function exportJson()
    {
        $json = array(
            'name' => $this->name,
            'key' => $this->scoreKey,
            'length' => $this->showLength,
            'order' => $this->orderType
        );
        if($this->toDollarRate > 0) {
            $json['toDollarRate'] = $this->toDollarRate;
        }
        if($this->disabled) {
            $json['disabled'] = 1;
        }
        $json['defTime'] = empty($this->defaultTime) ? 0 : $this->defaultTime->getTimestamp();
        return $json;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getShowLength(): ?int
    {
        return $this->showLength;
    }

    public function setShowLength(int $showLength): self
    {
        $this->showLength = $showLength;

        return $this;
    }

    /**
     * Set scoreKey.
     *
     * @param string $scoreKey
     *
     * @return ScoreMode
     */
    public function setScoreKey($scoreKey)
    {
        $this->scoreKey = $scoreKey;

        return $this;
    }

    /**
     * Get scoreKey.
     *
     * @Groups({"basic"})
     * @return string
     */
    public function getScoreKey()
    {
        return $this->scoreKey;
    }

    /**
     * Set createTime.
     *
     * @param \DateTime $createTime
     *
     * @return ScoreMode
     */
    public function setCreateTime($createTime)
    {
        $this->createTime = $createTime;

        return $this;
    }

    /**
     * Get createTime.
     *
     * @return \DateTime
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }

    /**
     * Set client.
     *
     * @param \MainBundle\Entity\Client|null $client
     *
     * @return ScoreMode
     */
    public function setClient(\MainBundle\Entity\Client $client = null)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client.
     *
     * @return \MainBundle\Entity\Client|null
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return ScoreMode
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @Groups({"basic"})
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set orderType.
     *
     * @param int $orderType
     *
     * @return ScoreMode
     */
    public function setOrderType($orderType)
    {
        $this->orderType = $orderType;

        return $this;
    }

    /**
     * Get orderType.
     *
     * @return int
     */
    public function getOrderType()
    {
        return $this->orderType;
    }

    /**
     * Set disabled.
     *
     * @param bool $disabled
     *
     * @return ScoreMode
     */
    public function setDisabled($disabled)
    {
        $this->disabled = $disabled;

        return $this;
    }

    /**
     * Get disabled.
     *
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * Set deleteTime.
     *
     * @param \DateTime|null $deleteTime
     *
     * @return ScoreMode
     */
    public function setDeleteTime($deleteTime = null)
    {
        $this->deleteTime = $deleteTime;

        return $this;
    }

    /**
     * Get deleteTime.
     *
     * @return \DateTime|null
     */
    public function getDeleteTime()
    {
        return $this->deleteTime;
    }

    public function notDeleted()
    {
        return empty($this->deleteTime);
    }

    /**
     * Set defaultTime.
     *
     * @param \DateTime|null $defaultTime
     *
     * @return ScoreMode
     */
    public function setDefaultTime($defaultTime = null)
    {
        $this->defaultTime = $defaultTime;

        return $this;
    }

    /**
     * Get defaultTime.
     *
     * @return \DateTime|null
     */
    public function getDefaultTime()
    {
        return $this->defaultTime;
    }

    /**
     * Set toDollarRate.
     *
     * @param int $toDollarRate
     *
     * @return ScoreMode
     */
    public function setToDollarRate($toDollarRate)
    {
        $this->toDollarRate = $toDollarRate;

        return $this;
    }

    /**
     * Get toDollarRate.
     *
     * @return int
     */
    public function getToDollarRate()
    {
        return $this->toDollarRate;
    }
}
