<?php

namespace MainBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * System
 *
 * @ORM\Table(name="system")
 * @ORM\Entity
 */
class System
{
    const YESTERDAY_OVERVIEW = 'yesterdayOverview';
    const YESTERDAY_OVERVIEW2 = 'yesterdayOverview2';
    const JUROR_POWER = 'jurorPower';

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="dataKey", type="string", length=31, unique=true)
     */
    private $dataKey;

    /**
     * @var string
     *
     * @ORM\Column(name="dataValue", type="string", length=255)
     */
    private $dataValue;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dataKey
     *
     * @param string $dataKey
     *
     * @return System
     */
    public function setDataKey($dataKey)
    {
        $this->dataKey = $dataKey;

        return $this;
    }

    /**
     * Get dataKey
     *
     * @return string
     */
    public function getDataKey()
    {
        return $this->dataKey;
    }

    /**
     * Set dataValue
     *
     * @param string $dataValue
     *
     * @return System
     */
    public function setDataValue($dataValue)
    {
        $this->dataValue = $dataValue;

        return $this;
    }

    /**
     * Get dataValue
     *
     * @return string
     */
    public function getDataValue()
    {
        return $this->dataValue;
    }
}
