<?php

namespace MainBundle\Entity;

use MainBundle\Repository\UserLicenseRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="user_license")
 * @ORM\Entity
 */
class UserLicense
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", name="user_id")
     */
    private $wpUserId;

    /**
     * @ORM\Column(type="string", length=32)
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=254, name="couponCode")
     */
    private $couponCode;

    /**
     * @ORM\Column(type="integer")
     */
    private $maxaccess;

    /**
     * the license id
     * @ORM\Column(type="integer")
     */
    private $licenseid;

    /**
     * the game content post id
     * @ORM\Column(type="integer")
     */
    private $license;

    /**
     * @ORM\Column(type="string", length=32, nullable=true, name="startDate")
     */
    private $startDate;

    /**
     * @ORM\Column(type="string", length=32, nullable=true, name="endDate")
     */
    private $endDate;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     */
    private $date;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getCouponCode(): ?string
    {
        return $this->couponCode;
    }

    public function setCouponCode(string $couponCode): self
    {
        $this->couponCode = $couponCode;

        return $this;
    }

    public function getMaxaccess(): ?int
    {
        return $this->maxaccess;
    }

    public function setMaxaccess(int $maxaccess): self
    {
        $this->maxaccess = $maxaccess;

        return $this;
    }

    public function getLicenseid(): ?int
    {
        return $this->licenseid;
    }

    public function setLicenseid(int $licenseid): self
    {
        $this->licenseid = $licenseid;

        return $this;
    }

    public function getLicense(): ?int
    {
        return $this->license;
    }

    public function setLicense(int $license): self
    {
        $this->license = $license;

        return $this;
    }

    public function getStartDate(): ?string
    {
        return $this->startDate;
    }

    public function setStartDate(?string $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?string
    {
        return $this->endDate;
    }

    public function setEndDate(?string $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getDate(): ?string
    {
        return $this->date;
    }

    public function setDate(?string $date): self
    {
        $this->date = $date;

        return $this;
    }

    /**
     * Set wpUserId.
     *
     * @param int $wpUserId
     *
     * @return UserLicense
     */
    public function setWpUserId($wpUserId)
    {
        $this->wpUserId = $wpUserId;

        return $this;
    }

    /**
     * Get wpUserId.
     *
     * @return int
     */
    public function getWpUserId()
    {
        return $this->wpUserId;
    }
}
