<?php

namespace MainBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UserState
 *
 * @ORM\Table(uniqueConstraints={@ORM\UniqueConstraint(name="state_unique", columns={"client_id", "username", "category", "stateKey"})})
 * @ORM\Entity
 */
class UserState
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="MainBundle\Entity\Client", inversedBy="userStates")
     * @ORM\JoinColumn(name="client_id", referencedColumnName="id")
     */
    private $client;
    
    /**
     * @var string
     *
     * @ORM\Column(name="username", type="string", length=255)
     */
    private $username;

    /**
     * @var string
     *
     * @ORM\Column(name="category", type="string", length=127)
     */
    private $category;

    /**
     * @var string
     *
     * @ORM\Column(name="stateKey", type="string", length=127)
     */
    private $stateKey;

    /**
     * @var string
     *
     * @ORM\Column(name="stateValue", type="text")
     */
    private $stateValue;
    
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="time", type="datetimetz")
     */
    private $time;

    public function exportShortJson()
    {
    	return array(
    			'username' => $this->username,
    			'category' => $this->category,
    			'key' => $this->stateKey,
    			'value' => $this->stateValue,
    			'time' => $this->time->getTimestamp()
    	);
    }
    public function importShortJson($json)
    {
    	$this->username = $json['username'];
    	$this->category = $json['category'];
    	$this->stateKey = $json['key'];
    	$this->stateValue = $json['value'];
    	$this->time = new \DateTime($json['time']);
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set username
     *
     * @param string $username
     *
     * @return UserState
     */
    public function setUsername($username)
    {
    	$this->username = $username;
    
    	return $this;
    }
    
    /**
     * Get username
     *
     * @return string
     */
    public function getUsername()
    {
    	return $this->username;
    }

    /**
     * Set category
     *
     * @param string $category
     *
     * @return UserState
     */
    public function setCategory($category)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * Get category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * Set stateKey
     *
     * @param string $stateKey
     *
     * @return UserState
     */
    public function setStateKey($stateKey)
    {
        $this->stateKey = $stateKey;

        return $this;
    }

    /**
     * Get stateKey
     *
     * @return string
     */
    public function getStateKey()
    {
        return $this->stateKey;
    }

    /**
     * Set stateValue
     *
     * @param string $stateValue
     *
     * @return UserState
     */
    public function setStateValue($stateValue)
    {
        $this->stateValue = $stateValue;

        return $this;
    }

    /**
     * Get stateValue
     *
     * @return string
     */
    public function getStateValue()
    {
        return $this->stateValue;
    }

    /**
     * Set client
     *
     * @param \MainBundle\Entity\Client $client
     *
     * @return UserState
     */
    public function setClient(\MainBundle\Entity\Client $client = null)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client
     *
     * @return \MainBundle\Entity\Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Set time
     *
     * @param \DateTime $time
     *
     * @return UserState
     */
    public function setTime($time)
    {
        $this->time = $time;

        return $this;
    }

    /**
     * Get time
     *
     * @return \DateTime
     */
    public function getTime()
    {
        return $this->time;
    }
}
