<?php
namespace MainBundle\EntityManager;

use Doctrine\ORM\QueryBuilder;
use MainBundle\Libs\Common\BaseManager;

abstract class AbstractEntityManager extends BaseManager
{
    /**
     *
     * @return \Doctrine\Common\Persistence\ObjectManager
     */
    public function getDocMgr()
    {
        return $this->controller->getService('doctrine')->getManager();
    }
    /**
     *
     * @param unknown $repoClass
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    public function getRepo($repoClass): \Doctrine\ORM\EntityRepository
    {
        return $this->controller->getService('doctrine')->getRepository($repoClass);
    }

    /**
     *
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    public function getThisRepo()
    {
        throw new \Error('not implemented');
    }

    /**
     *
     * @param integer $id
     * @return object
     */
    public function getById($id)
    {
        return $this->getThisRepo()->find($id);
    }

    /**
     *
     * @param integer[] $id
     * @return object[]
     */
    public function listByIds($ids)
    {
        return $this->getThisRepo()->findByid($ids);
    }

    public function convertEntitiesToIds($entities)
    {
        $ids = array();
        foreach ($entities as $e) {
            $ids[] = $e->getId();
        }
        return $ids;
    }

    public function printQueryBuilderSql(QueryBuilder $query)
    {
        return print_r(array('sql' => $query->getQuery()->getSQL(), 'params' => $query->getParameters()));
    }

    public function listAll($start, $length)
    {
        /* @var $builder QueryBuilder */
        $builder = $this->getThisRepo()->createQueryBuilder('e')
            ->setFirstResult($start)
            ->setMaxResults($length)
        ;

        return $builder->getQuery()->getResult();
    }

    public function flush() {
        $this->getDocMgr()->flush();
    }

    public function objToJson($object, $group = null) {
        $this->controller->objToJson($object, $group);
    }
    public function listToJson($object, $group = null) {
        $this->controller->listToJson($object, $group);
    }
}
