<?php

namespace MainBundle\EntityManager;

use MainBundle\Entity\DemoEmail;
use MainBundle\Utils\StringUtil;

class DemoEmailManager extends AbstractEntityManager
{
    /**
     * (non-PHPdoc)
     * @see \MainBundle\EntityManager\AbstractEntityManager::getThisRepo()
     */
    public function getThisRepo(): \Doctrine\ORM\EntityRepository
    {
        return $this->getRepo('MainBundle:DemoEmail');
    }

    public function getByEmail($email): ?DemoEmail
    {
        return $this->getThisRepo()->findOneByemail($email);
    }

    public function registerEmail($email, $name, $source, $receivable): ?DemoEmail
    {
        $this->designContract(filter_var($email, FILTER_VALIDATE_EMAIL), 'Invalid email format');
        $demoEmail = $this->getByEmail($email);
        if (empty($demoEmail)) {
            $demoEmail = new DemoEmail();
            $demoEmail->setEmail($email)
                ->setCount(1)
                ->setCreateTime(new \DateTime())
                ->setModifyTime(new \DateTime());
            $this->getDocMgr()->persist($demoEmail);
        } else {
            $demoEmail->setCount($demoEmail->getCount() + 1);
            $demoEmail->setModifyTime(new \DateTime());
        }

        $sources = empty($demoEmail->getSources()) ? [] : json_decode($demoEmail->getSources());
        $sources[] = $source;

        $demoEmail->setModifyTime(new \DateTime())
        ->setSources(json_encode($sources))
        ->setReceivable(!empty($receivable))
        ;
        $this->flush();
        return $demoEmail;
    }
}
