<?php
namespace MainBundle\EntityManager;

use MainBundle\Entity\System;

class SystemManager extends AbstractEntityManager
{


    /**
     * (non-PHPdoc)
     * @see \MainBundle\EntityManager\AbstractEntityManager::getThisRepo()
     */
    public function getThisRepo()
    {
        return $this->getRepo('MainBundle:System');
    }

    /**
     * @param string $key
     * @return \MainBundle\Entity\System | NULL
     */
    public function getByKey($key)
    {
        return $this->getThisRepo()->findOneBydataKey($key);
    }

    /**
     * @param string $key
     * @return string
     */
    public function getValue($key)
    {
        $system = $this->getByKey($key);
        return empty($system) ? null : $system->getDataValue();
    }

    /**
     * @param string $key
     * @param string $value
     */
    public function setValue($key, $value)
    {
        $system = $this->getByKey($key);
        if(empty($system)) {
            $system = new System();
            $system->setDataKey($key);
            $this->getDocMgr()->persist($system);
        }
        $system->setDataValue($value);
        $this->getDocMgr()->flush();
        return $system;
    }

    /**
     * @param string $key
     * @param \DateTime $value
     */
    public function setTime($key, \DateTime $value)
    {
        $this->setDataValue($key, ''.$value->getTimestamp());
    }

    /**
     * @param string $key
     * @return \DateTime $value
     */
    public function getTime($key)
    {
        $value = $this->getValue($key);
        if(empty($value)) {
            return null;
        }
        $time = new \DateTime();
        $time->setTimestamp(intval($value));
        return $time;
    }

    /**
     * @param string $key
     * @param int $value
     */
    public function setInt($key, $value)
    {
        $this->setDataValue($key, ''.$value);
    }

    /**
     * @param string $key
     * @return int $value
     */
    public function getInt($key)
    {
        $value = $this->getValue($key);
        if(empty($value)) {
            return 0;
        }
        return intval($value);
    }

    /**
     * @param string $key
     * @param float $value
     */
    public function setFloat($key, $value)
    {
        $this->setDataValue($key, ''.$value);
    }

    /**
     * @param string $key
     * @return float $value
     */
    public function getFloat($key)
    {
        $value = $this->getValue($key);
        if(empty($value)) {
            return 0;
        }
        return floatval($value);
    }


    // not related to db
    public function generateIdeAmBox($appName, $forceAnonymous)
	{
		$now = new \DateTime();
		$AmBox = array(
            'rootUrl' => $this->generateUrl('app', ['appName'=>$appName]),
            'timestamp' => $now->getTimestamp(),
        );

        $userManager = new UserManager($this->controller);
        if($forceAnonymous) {
            $user = $userManager->getAnonymousUser();
        } else {
            $this->getWpService()->loadWordpress();
            $wpUser = \wp_get_current_user();

            $userManager = new UserManager($this->controller);
            /* @var $user User */
            $user = null;

            if (!empty($wpUser) && !empty($wpUser->ID)) {
                $user = $userManager->convertWpUserToUser($wpUser);
            } else {
                $user = $userManager->getAnonymousUser();
            }
        }
        
        $AmBox['user'] = $this->controller->objToJson($user);
        $AmBox['userToken'] = $user->getAccessToken();
		return $AmBox;
    }
}
