<?php
namespace MainBundle\EntityManager;

use MainBundle\Entity\Abstracts\AbstractUserScore;
use MainBundle\Entity\UserScoreDaily;

class UserScoreDailyManager extends AbstractUserScoreManager
{
	public function createUserScore(): AbstractUserScore
	{
		return new UserScoreDaily();
	}
	public function getEntityRepo(): \Doctrine\ORM\EntityRepository
	{
		return $this->getRepo('MainBundle:UserScoreDaily');
	}
	public function getPeriodStartByTime(\DateTime $time): \DateTime
	{
		$timestamp = $time->getTimestamp();
		// one day = 60 sec * 60 min * 24 hour
		$interval = 86400;
		$date = new \DateTime();
		$date->setTimestamp(floor($timestamp / $interval) * $interval);
		return $date;
	}

	public function sysListClientsTopScoresByOwner($clientOwnername, $scoreKey, \DateTime $fromTime)
	{
		$userManager = new UserManager($this->controller);
		$user = $userManager->getSystemUser();

		//$clientManager = new ClientManager($this->controller);
		//$client = $clientManager->getSystemClientByOwner($clientOwnername);

		$query = $this->getEntityRepo()->createQueryBuilder('s')
		->select('c.code as clientCode, max(s.score) as score')
		->join('s.scoreMode', 'm', 'WITH', 'm.scoreKey = :key')
		->join('m.client', 'c', 'WITH', 'c.ownername = :ownername')
		->where('IDENTITY(s.user) = :uid')
		->andwhere('s.periodStart >= :period')
		->setParameter('uid', $user->getId())
		->setParameter('key', $scoreKey)
		->setParameter('ownername', $clientOwnername)
		->setParameter('period', $this->getPeriodStartByTime($fromTime))
		->groupBy('c.id')
		;

		$result = $query->getQuery()->getResult();
		$clients = array();
		$ownerScore = 0;
        foreach($result as $data) {
			// @see ClientManager->getSystemClientByClient(),
			$params = explode('/', $data['clientCode']);
			if($params[1] == 'client') {
				$clients[$params[2]] = intval($data['score']);
			} else if($params[1] == 'owner') {
				$ownerScore = intval($data['score']);
			}
			
        }
        return array(
			'clients' => $clients,
			'owner' => $ownerScore
		);
	}

	public function sysListClientsTotalScoresByOwner($clientOwnername, $scoreKey, \DateTime $fromTime)
	{
		$userManager = new UserManager($this->controller);
		$user = $userManager->getSystemUser();

		$query = $this->getEntityRepo()->createQueryBuilder('s')
		->select('c.code as clientCode, sum(s.score) as score')
		->join('s.scoreMode', 'm', 'WITH', 'm.scoreKey = :key')
		->join('m.client', 'c', 'WITH', 'c.ownername = :ownername')
		->where('IDENTITY(s.user) = :uid')
		->andwhere('s.periodStart >= :period')
		->setParameter('uid', $user->getId())
		->setParameter('key', $scoreKey)
		->setParameter('ownername', $clientOwnername)
		->setParameter('period', $this->getPeriodStartByTime($fromTime))
		->groupBy('c.id')
		;
		
		$result = $query->getQuery()->getResult();
		$clients = array();
		$ownerScore = 0;
        foreach($result as $data) {
			// @see ClientManager->getSystemClientByClient(),
			$params = explode('/', $data['clientCode']);
			if($params[1] == 'client') {
				$clients[$params[2]] = intval($data['score']);
			} else if($params[1] == 'owner') {
				$ownerScore = intval($data['score']);
			}
			
        }
        return array(
			'clients' => $clients,
			'owner' => $ownerScore
		);
	}
}