<?php

namespace MainBundle\EntityManager;

use MainBundle\Data\ScoreSubmitType;
use MainBundle\Entity\Abstracts\AbstractUserScore;
use MainBundle\Entity\UserScoreHistory;
use MainBundle\Entity\Client;
use MainBundle\Entity\GameItem;
use MainBundle\Entity\User;

class UserScoreHistoryManager extends AbstractUserScoreManager
{
	public function createUserScore(): AbstractUserScore
	{
		return new UserScoreHistory();
	}
	public function getEntityRepo(): \Doctrine\ORM\EntityRepository
	{
		return $this->getRepo('MainBundle:UserScoreHistory');
	}
	public function getPeriodStartByTime(\DateTime $time): \DateTime
	{
		return new \DateTime('2019-01-01');
	}

	public function listFullCurrencyScoresJsonByUser(Client $client, User $user)
	{
		$modes = $this->listCurrencyScoreModes($client);
		$scores = $this->listScoresByScoreModes($modes, $user);
		$scoreMap = array();
		foreach ($scores as $score) {
			$scoreMap[$score->getScoreMode()->getScoreKey()] = $score;
		}
		$list = array();
		foreach ($modes as $mode) {
			$key = $mode->getScoreKey();
			if (empty($scoreMap[$key])) {
				$score = new UserScoreHistory();
				$score->setScore(0)->setScoreMode($mode)->setTime(new \DateTime())->setUser($user);
			} else {
				$score = $scoreMap[$key];
			}
			$list[] = $score->exportJsonWithScoreMode();
		}
		return $list;
	}

	public function makePayment(Client $client, User $user, GameItem $gameItem, $count, $pays)
	{
		$hasPayment = false;
		$payments = array();
		$scoreModeKeys = array();
		foreach ($pays as $pay) {
			$key = $pay['k'];
			$amount = $pay['v'];
			if (empty($amount)) {
				continue;
			}
			$payments[$key] = $amount;
			$scoreModeKeys[] = $key;
			$hasPayment = true;
		}

		$deposits = array();

		$this->designContract($hasPayment, 'No payments provided.');

		$scoreModes = $this->listScoreModesByKeys($client, $scoreModeKeys);
		$scoreModeMap = array();
		foreach ($scoreModes as $mode) {
			$scoreModeMap[$mode->getScoreKey()] = $mode;
		}

		$paymentTotal = 0;
		foreach ($payments as $key => $amount) {
			$this->designContract(!empty($scoreModeMap[$key]), "Currency '$key' does not exist.");
			/** @var \MainBundle\Entity\ScoreMode $mode */
			$mode = $scoreModeMap[$key];
			$this->designContract($mode->getToDollarRate() > 0, "'$key' is not a valid currency.");
			$paymentTotal += $amount * $mode->getToDollarRate();
		}

		$this->designContract($paymentTotal == $gameItem->getPriceInGameDollar() * $count, 'Item price does not match payments.');

		$scores = $this->listScoresByScoreModes($scoreModes, $user);
		$scoreMap = array();
		foreach ($scores as $score) {
			$scoreMap[$score->getScoreMode()->getScoreKey()] = $score;
		}

		foreach ($payments as $key => $amount) {
			$score = 0;
			$scoreObj = null;
			if (!empty($scoreMap[$key])) {
				/** @var \MainBundle\Entity\Abstracts\AbstractUserScore $scoreObj */
				$scoreObj = $scoreMap[$key];
				$score = $scoreObj->getScore();
			}
			$newDeposit = $score - $amount;
			$this->designContract($newDeposit >= 0, "Insufficient deposit of '$key'");
			if (empty($scoreObj)) {
				$this->submitScore($user, $scoreModeMap[$key], $newDeposit, ScoreSubmitType::SUBMIT_OVERWRITE, false);
			} else {
				$scoreObj->setScore($newDeposit);
			}
			$deposits[$key] = $newDeposit;
		}
		$this->flush();

		return array(
			'deposits' => $deposits,
			'paymentTotal' => $paymentTotal
		);
	}
}
