<?php
namespace MainBundle\EntityManager;

use MainBundle\Entity\Abstracts\AbstractUserScore;
use MainBundle\Entity\UserScoreMonthly;

class UserScoreMonthlyManager extends AbstractUserScoreManager
{
	public function createUserScore(): AbstractUserScore
	{
		return new UserScoreMonthly();
	}
	public function getEntityRepo(): \Doctrine\ORM\EntityRepository
	{
		return $this->getRepo('MainBundle:UserScoreMonthly');
	}
	public function getPeriodStartByTime(\DateTime $time): \DateTime
	{
		$date = new \DateTime();
		$date->setTimestamp(mktime(0, 0, 0, $time->format('n'), 1, $time->format('Y')));
		return $date;
	}
}