<?php
namespace MainBundle\EntityManager;

use MainBundle\Entity\Abstracts\AbstractUserScore;
use MainBundle\Entity\UserScoreWeekly;

class UserScoreWeeklyManager extends AbstractUserScoreManager
{
	public function createUserScore(): AbstractUserScore
	{
		return new UserScoreWeekly();
	}
	public function getEntityRepo(): \Doctrine\ORM\EntityRepository
	{
		return $this->getRepo('MainBundle:UserScoreWeekly');
	}
	public function getPeriodStartByTime(\DateTime $time): \DateTime
	{
		$date = new \DateTime();
		$date->setTimestamp(strtotime('last sunday', $time->getTimeStamp() + 86400));
		return $date;
	}
}