<?php
namespace MainBundle\EntityManager;

use MainBundle\Entity\Client;
use MainBundle\Entity\User;
use MainBundle\Entity\UserState;
use Doctrine\ORM\QueryBuilder;

class UserStateManager extends AbstractEntityManager
{
	/**
	 * 
	 * @param Client $client
	 * @param string $username
	 * @param string $category
	 * @param string $key
	 * @return \MainBundle\Entity\UserState
	 */
	public function getOneState(Client $client, $username, $category, $key)
	{
		$query = $this->getRepo('MainBundle:UserState')->createQueryBuilder('s')
		->where('IDENTITY(s.client) = :gid')
		->andwhere('s.username = :uname')
		->andwhere('s.category = :cat')
		->andwhere('s.stateKey = :key')
		->setParameter('gid', $client->getId())
		->setParameter('uname', $username)
		->setParameter('cat', $category)
		->setParameter('key', $key)
		;
		
		return $query->getQuery()->getOneOrNullResult();
	}
	
	/**
	 * 
	 * @param Client $client
	 * @param string $username
	 * @param string $category
	 * @param string $key
	 * @param string $value
	 * @return \MainBundle\Entity\UserState
	 */
	public function setOneState(Client $client, $username, $category, $key, $value)
	{
		$state = $this->getOneState($client, $username, $category, $key);
		if(empty($state))
		{
			$state = new UserState();
			$state->setClient($client)
			->setUsername($username)
			->setCategory($category)
			->setStateKey($key)
			;
			$this->getDocMgr()->persist($state);
		}
		$state->setStateValue($value)
		->setTime(new \DateTime());
		$this->getDocMgr()->flush();
		return $state;
	}
	
	/**
	 * 
	 * @param Client $client
	 * @param string $username
	 * @param string $category
	 * @param string $key
	 * @return interger
	 */
	public function removeOneState(Client $client, $username, $category, $key)
	{
		/* @var $builder QueryBuilder */
		$builder = $this->getRepo('MainBundle:UserState')->createQueryBuilder('s');
		$query = $builder->delete()
		->where('IDENTITY(s.client) = :cid')
		->andwhere('s.username = :uname')
		->andwhere('s.category = :cat')
		->andwhere('s.stateKey = :key')
		->setParameter('cid', $client->getId())
		->setParameter('uname', $username)
		->setParameter('cat', $category)
		->setParameter('key', $key)
		;
		return $query->getQuery()->execute();
	}
	
	public function getStates(Client $client, $usernames, $categories, $keys)
	{
		$query = $this->getRepo('MainBundle:UserState')->createQueryBuilder('s')
		->where('IDENTITY(s.client) = :cid')
		->setParameter('cid', $client->getId())
		;
		if(!empty($usernames))
		{
			$query->andwhere('s.username in (:unames)')
			->setParameter('unames', $usernames);
		}
		if(!empty($categories))
		{
			$query->andwhere('s.category in (:cats)')
			->setParameter('cats', $categories);
		}
		if(!empty($keys))
		{
			$query->andwhere('s.stateKey in (:keys)')
			->setParameter('keys', $keys);
		}
		
		return $query->getQuery()->getResult();
	}
	
	public function removeStates(Client $client, $usernames, $categories, $keys)
	{
		/* @var $builder QueryBuilder */
		$builder = $this->getRepo('MainBundle:UserState')->createQueryBuilder('s');
		$query = $builder->delete()
		->where('IDENTITY(s.client) = :cid')
		->setParameter('cid', $client->getId())
		;
		if(!empty($usernames))
		{
			$query->andwhere('s.username in (:unames)')
			->setParameter('unames', $usernames);
		}
		if(!empty($categories))
		{
			$query->andwhere('s.category in (:cats)')
			->setParameter('cats', $categories);
		}
		if(!empty($keys))
		{
			$query->andwhere('s.stateKey in (:keys)')
			->setParameter('keys', $keys);
		}
		return $query->getQuery()->execute();
	}
	
	/**
	 * 
	 * @param Client $client
	 */
	public function cleanByClient(Client $client)
	{
		/* @var $builder QueryBuilder */
		$builder = $this->getRepo('MainBundle:UserState')->createQueryBuilder('s')
		->delete()
		->where('s.client = :client')
		->setParameter('client', $client)
		;
		$builder->getQuery()->execute();
	}
}