<?php
namespace MainBundle\EventListener;

use Symfony\Component\HttpKernel\Event\GetResponseForExceptionEvent;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\HttpExceptionInterface;
use MainBundle\Exception\ApiException;

class ApiExceptionListener
{
	public function onKernelException(GetResponseForExceptionEvent $event)
	{
		// You get the exception object from the received event
		$exception = $event->getException();
		
		if (!$exception instanceof ApiException) {
			return;
		}
		
		// Customize your response object to display the exception details
		$response = new Response();
		$response->setContent($exception->getMessage());

		$response->setStatusCode(400);
		// Send the modified response object to the event
		$event->setResponse($response);
		
		
	}
}