<?php
namespace MainBundle\EventListener;

use MainBundle\Services\WpService;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Http\HttpUtils;
use Symfony\Component\Security\Http\Logout\DefaultLogoutSuccessHandler;

class LogoutSuccessHandler extends DefaultLogoutSuccessHandler {

    private $wpService;

    public function __construct(HttpUtils $httpUtils, string $targetUrl = '/', WpService $wpService)
    {
        parent::__construct($httpUtils, $targetUrl);
        $this->wpService = $wpService;
    }

    /**
     * {@inheritdoc}
     */
    public function onLogoutSuccess(Request $request)
    {
        $this->wpService->loadWordpress();
        \wp_logout();
        return parent::onLogoutSuccess($request);
    }
}