<?php
namespace MainBundle\EventListener;

use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Translation\TranslatorInterface;

class RequestListener
{
    public function __construct(Kernel $kernel, TranslatorInterface $translator)
    {
        $this->kernel = $kernel;
        $this->translator = $translator;
    }

    public function onKernelRequest(GetResponseEvent $event)
	{
		$request = $event->getRequest();
		if($request->cookies->has('userLocale')) {
            $request->setLocale($request->cookies->get('userLocale'));
            $this->translator->setLocale($request->cookies->get('userLocale'));
		}
	}
}