<?php
namespace MainBundle\EventListener;

use Symfony\Component\HttpKernel\Event\FilterResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Kernel;

class ResponseListener
{
	private $domain;

    public function __construct(Kernel $kernel, $domain)
    {
		$this->kernel = $kernel;
		$this->domain = $domain;
    }

    public function onKernelResponse(FilterResponseEvent $event)
	{
		if (!$event->isMasterRequest()) {
		    return;
		}
		$request = $event->getRequest();
		$response = $event->getResponse();
		$requestOrigin = $request->headers->get('Origin');
		$allowOrigin = $request->getSchemeAndHttpHost();

		//echo $this->kernel->getEnvironment() . '/' . $requestOrigin . '/';
		
		if($this->kernel->getEnvironment() == "dev")
		{
			if(preg_match('/^http(s)?:\/\/(localhost|127\.0\.0\.1):[0-9]+/', $requestOrigin))
			{
				$allowOrigin = $requestOrigin;
			}
		}
		else if(preg_match('/^http(s)?:\/\/(www\.)?'.$this->domain.'/', $requestOrigin))
		{
			if(strpos($request->getRequestUri(), '/api/') === 0)
			{
				// comment this out at production
				$allowOrigin = $requestOrigin;
			}
		}
		else if(preg_match('/^http(s)?:\/\/(localhost|127\.0\.0\.1):[0-9]+/', $requestOrigin))
		{
			$allowOrigin = $requestOrigin;
		}

		$response->headers->set('Access-Control-Allow-Origin', $allowOrigin);
		$response->headers->set('Very', 'Origin');
		
		if($response->headers->hasCacheControlDirective('s-maxage')) {
			$response->setMaxAge($response->headers->getCacheControlDirective('s-maxage'));
		}
	}
}