<?php
namespace MainBundle\Libs\Common;

use MainBundle\Controller\IControllerBase;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use MainBundle\Exception\ManagerException;
use MainBundle\Services\WpService;

class BaseManager {
	/**
	 *
	 * @var IControllerBase
	 */
	protected $controller;
	
	protected $adminMode = false;

	private $s3Syncer = null;

	public function __construct(IControllerBase $controller)
	{
		$this->controller = $controller;
	}

	public function getWpService(): WpService
	{
		return $this->controller->getService('wp_service');
	}

	/**
	 * @return \MainBundle\Libs\S3\S3Syncer
	 */
	public function getS3Syncer()
	{
		if($this->s3Syncer == null) {
			$this->s3Syncer = new \MainBundle\Libs\S3\S3Syncer($this->controller);
		}
		return $this->s3Syncer;
	}

	public function setAdminMode()
	{
		$this->adminMode = true;
	}
	
	public function designContract($condition, $errorMessage)
	{
		if ($condition) {
			return;
		}
		//throw new ManagerException($errorMessage . '::' . json_encode(debug_backtrace()));
		throw new ManagerException($errorMessage);
	}
	

	/**
	 * @return string
	 */
	public function getRootDir()
	{
		return $this->controller->getService('kernel')->getRootDir();
	}
	
	/**
	 * @return \Psr\Log\LoggerInterface
	 */
	public function getLogger()
	{
		return $this->controller->getService('logger');
	}
	
	/**
	 * Generates a URL from the given parameters.
	 *
	 * @param string $route         The name of the route
	 * @param mixed  $parameters    An array of parameters
	 * @param int    $referenceType The type of reference (one of the constants in UrlGeneratorInterface)
	 *
	 * @return string The generated URL
	 *
	 * @see UrlGeneratorInterface
	 */
	public function generateUrl($route, $parameters = array(), $referenceType = UrlGeneratorInterface::ABSOLUTE_PATH)
	{
		return $this->controller->getService('router')->generate($route, $parameters, $referenceType);
	}
	
	/**
	 *
	 * @return \MainBundle\Entity\User
	 */
	public function getMe()
	{
		return $this->controller->getMyUser();
	}

	/**
	 *
	 * @param string $key
	 * @param array $params
	 * @param string $domain
	 * @param string $locale
	 * 
	 * @return string
	 */
	public function getTranslation($key, $params = array(), $domain = null, $locale = null)
	{
		return $this->controller->getService('translator')->trans($key, $params, $domain, $locale);
	}
}