<?php
namespace MainBundle\Security\Core\User;

use HWI\Bundle\OAuthBundle\OAuth\Response\UserResponseInterface;
use HWI\Bundle\OAuthBundle\Security\Core\User\FOSUBUserProvider as BaseClass;
use MainBundle\Entity\User;
use FOS\UserBundle\Model\UserManagerInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Ekino\WordpressBundle\Entity\User as WpUser;
use MainBundle\Exception\ManagerException;
use MainBundle\Services\WpService;
use MainBundle\Utils\StringUtil;

class FOSUBUserProvider extends BaseClass {

    /** @var WpService */
    private $wpService;

    public function __construct(UserManagerInterface $userManager, array $properties,
        WpService $wpService
        )
    {
        parent::__construct($userManager, $properties);
        $this->wpService = $wpService;
    }

    /**
     * {@inheritDoc}
     */
    public function connect(UserInterface $user, UserResponseInterface $response)
    {
        $property = $this->getProperty($response);
        $username = $response->getUsername();

        //on connect - get the access token and the user ID
        $service = $response->getResourceOwner()->getName();

        $setter = 'set' . ucfirst($service);
        $setter_id = $setter . 'Id';
        $setter_token = $setter . 'AccessToken';

        //we "disconnect" previously connected users
        if (null !== $previousUser = $this->userManager->findUserBy(array($property => $username))) {
            $previousUser->$setter_id(null);
            $previousUser->$setter_token(null);
            $this->userManager->updateUser($previousUser);
        }

        //we connect current user
        $user->$setter_id($username);
        $user->$setter_token($response->getAccessToken());

        $this->userManager->updateUser($user);
    }

    /**
     * {@inheritdoc}
     */
    public function loadUserByOAuthUserResponse(UserResponseInterface $response)
    {
        $service = $response->getResourceOwner()->getName();
        $username = $response->getUsername() . "@" . $service;
        $user = $this->userManager->findUserBy(array($this->getProperty($response) => $username));

        $setter = 'set' . ucfirst($service);
        $setter_id = $setter . 'Id';
        $setter_token = $setter . 'AccessToken';

        //when the user is registrating
        if (null === $user) {
            // create new user here
            $user = $this->userManager->createUser();
            $user->$setter_id($response->getUsername());
            $user->$setter_token($response->getAccessToken());
            //I have set all requested data with the user's username
            //modify here with relevant data
            $user->setUsername($username);
            $user->setEmail($username);
            $user->setPassword(StringUtil::generateRandomString(10));
            $user->setEnabled(true);
            $this->user_update($user, $response, $service);

            $existingUser = $this->userManager->findUserByEmail($user->getEmail());
            if ($existingUser == null) {
                $this->userManager->updateUser($user);
                return $user;
            }

            $user = $existingUser;
            $user->setUsername($username);
            $user->$setter_id($response->getUsername());
        } else {
            //if user exists - go with the HWIOAuth way
            $user = parent::loadUserByOAuthUserResponse($response);
        }
        //update access token
        $user->$setter_token($response->getAccessToken());
        
        $this->user_update($user, $response, $service);

        return $user;
    }

    private function user_update(User $user, UserResponseInterface $response, $service)
    {
        $userinfo = array();
        if (!empty($service)) {
            $nickname = '';
            $responseData = $response->getData();
            $responseData['rawToken'] = $response->getOAuthToken()->getRawToken();

            $directory = __DIR__.'/../../../../../var/login/';
            @mkdir($directory, 0777, true);
            $logFile = $directory.$user->getUsername().'_oauth_response.log';

            file_put_contents($logFile, $service. ":\n". json_encode($responseData, JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT));
            
            if ($service == 'google') {
                $nickname = $responseData['name'];
                $user->setEmail($responseData['email']);
                $user->setIconFile($responseData['picture']);
                $user->setProfileUrl(empty($responseData['link']) ? '' : $responseData['link']);
                $userinfo['firstname'] = $responseData['given_name'];
                $userinfo['lastname'] = $responseData['family_name'];
                if(!$responseData['verified_email']) {
                    throw new ManagerException('The email for this google account has not verified.');
                }
            } else if ($service == 'facebook') {
                $nickname = $responseData['name'];
                /*
                if(empty($responseData['email'])) {
                    $user->setEmail("{$responseData['id']}@facebook.com");
                } else {
                    $user->setEmail($responseData['email']);
                }
                */
                $user->setEmail("{$responseData['id']}@facebook.com");
                $user->setIconFile("https://graph.facebook.com/{$responseData['id']}/picture?width=140&height=140");
                $user->setProfileUrl('https://www.facebook.com/'.$responseData['id']);

            } else if ($service == 'twitter') {
                $nickname = $responseData['screen_name'];
                $user->setEmail($responseData['id_str'] . '@twitter.com');
                $user->setIconFile($responseData['profile_image_url_https']);
                if(isset($responseData['entities'], $responseData['entities']['url'], $responseData['entities']['url']['urls'], $responseData['entities']['url']['urls'][0])) {
                    $user->setProfileUrl($responseData['entities']['url']['urls'][0]['expanded_url']);
                }
            } else if ($service == 'yahoo') {
                $nickname = $responseData['profile']['nickname'];
                $user->setEmail($responseData['profile']['guid'] . '@yahoo.com');
                $user->setIconFile($responseData['profile']['image']['imageUrl']);
            } else if ($service == 'windows_live') {
                $nickname = $responseData['first_name'];
                /*
                if(!empty($responseData['emails']['preferred'])) {
                    $user->setEmail($responseData['emails']['preferred']);                    
                } else {
                    $user->setEmail($responseData['emails']['account']);
                }
                */
                $user->setEmail($responseData['id'].'@windows_live.com');
                $user->setIconFile("https://apis.live.net/v5.0/{$responseData['id']}/picture");
                $user->setProfileUrl($responseData['link']);
            } else if ($service == 'github') {
                $nickname = empty($responseData['name']) ? $responseData['login'] : $responseData['name'];
                //$user->setEmail(empty($responseData['email']) ? "{$responseData['login']}@github.com" : $responseData['email']);
                $user->setEmail("{$responseData['login']}@github.com");
                $user->setIconFile($responseData['avatar_url']);
                $user->setProfileUrl($responseData['html_url']);
            }

            $user->setService($service);
            $user->setNickname($nickname);
        }

        if (in_array($user->getEmail(), $this->properties['admin_emails'])) {
            $user->addRole(User::ROLE_SUPER_ADMIN);
        } else {
            $user->removeRole(User::ROLE_SUPER_ADMIN);
        }

        $this->updateWordpressUser($user, $userinfo);
    }

    private function updateWordpressUser(User $user, $userinfo)
    {
        
        /** @var WpUser $wpUser */
        $wpUser = $this->wpService->userManager->findOneBy(['login' => $user->getUsername()]);
        if(empty($wpUser)) {
            $wpUser = $this->wpService->userManager->create();
            $wpUser->setLogin($user->getUsername())
                ->setNicename($user->getNickname())
                ->setEmail($user->getEmail())
                ->setPass($user->getPassword())
                ->setRegistered(new \DateTime())
                ->setDisplayName($user->getNickname())
                ->setUrl('')
                ->setActivationKey('')
                ->setStatus(0)
                ;
            $this->wpService->userManager->save($wpUser, true);
        }
        
        $this->wpService->wordpress->loadWordpress();

        if($user->isSuperAdmin() && !\current_user_can('administractor')) {
            \update_user_meta($wpUser->getId(), 'wp_capabilities', 'a:13:{s:13:"administrator";b:1;s:26:"wpcf_custom_post_type_view";b:1;s:26:"wpcf_custom_post_type_edit";b:1;s:33:"wpcf_custom_post_type_edit_others";b:1;s:25:"wpcf_custom_taxonomy_view";b:1;s:25:"wpcf_custom_taxonomy_edit";b:1;s:32:"wpcf_custom_taxonomy_edit_others";b:1;s:22:"wpcf_custom_field_view";b:1;s:22:"wpcf_custom_field_edit";b:1;s:29:"wpcf_custom_field_edit_others";b:1;s:25:"wpcf_user_meta_field_view";b:1;s:25:"wpcf_user_meta_field_edit";b:1;s:32:"wpcf_user_meta_field_edit_others";b:1;}');
            \update_user_meta($wpUser->getId(), 'wp_user_level', '10');
        }

        \wp_clear_auth_cookie();
        \wp_set_current_user($wpUser->getId(), $wpUser->getLogin());
        \wp_set_auth_cookie($wpUser->getId(), true);

        if(!empty($userinfo['firstname']) && !empty($userinfo['lastname'])) {
            \wp_update_user([
                'ID' => $wpUser->getId(), // this is the ID of the user you want to update.
                'first_name' => $userinfo['firstname'],
                'last_name' => $userinfo['lastname'],
                'nickname' => $user->getNickname(),
            ]);
        }
    }
}
