<?php

namespace MainBundle\Services;

use Ekino\WordpressBundle\Manager\UserManager as WpUserManager;
use Ekino\WordpressBundle\Wordpress\Wordpress;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class WpService
{
    public $userManager;

    public $tokenStorage;

    public $wordpress;

    private $_wordpressLoaded = false;

    public function __construct(
        Wordpress $wordpress,
        WpUserManager $userManager,
        TokenStorageInterface $tokenStorage
    ) {
        $this->wordpress = $wordpress;
        $this->userManager = $userManager;
        $this->tokenStorage = $tokenStorage;
    }

    public function loadWordpress(): Wordpress
    {
        if (!$this->_wordpressLoaded) {
            $this->_wordpressLoaded = true;
            $this->wordpress->loadWordpress();
        }
        return $this->wordpress;
    }
}
