<?php
namespace MainBundle\Utils;

use Symfony\Component\Finder\Iterator\RecursiveDirectoryIterator;

class FileUtil
{
    public static function deleteDirectory($dirname)
    {
        if (!file_exists($dirname) || !is_dir($dirname)) {
            return false;
        }

        FileUtil::deleteSubDirectories($dirname);
        rmdir($dirname);
        return true;
    }

    public static function deleteSubDirectories($dirname)
    {
        if (!file_exists($dirname) || !is_dir($dirname)) {
            return false;
        }

        $it = new RecursiveDirectoryIterator($dirname, RecursiveDirectoryIterator::SKIP_DOTS);
        $files = new \RecursiveIteratorIterator($it, \RecursiveIteratorIterator::CHILD_FIRST);
        foreach ($files as $file) {
            if ($file->isDir()) {
                rmdir($file->getRealPath());
            } else {
                unlink($file->getRealPath());
            }
        }
        return true;
    }

    public static function deleteFileOrDirectory($filename)
    {
        if (!file_exists($filename)) {
            return false;
        }

        if (is_file($filename)) {
            unlink($filename);
            return true;
        }

        return FileUtil::deleteDirectory($filename);
    }

    public static function fullcopy($source, $dest)
    {
        // Check for symlinks
        if (is_link($source)) {
            return symlink(readlink($source), $dest);
        }

        // Simple copy for a file
        if (is_file($source)) {
            return copy($source, $dest);
        }

        // Make destination directory
        if (!is_dir($dest)) {
            mkdir($dest);
        }

        // Loop through the folder
        $dir = dir($source);
        while (false !== $entry = $dir->read()) {
            // Skip pointers
            if ($entry == '.' || $entry == '..') {
                continue;
            }

            // Deep copy directories
            FileUtil::fullcopy("$source/$entry", "$dest/$entry");
        }

        // Clean up
        $dir->close();
        return true;
    }

    public static function getExtFromFilename($filename)
    {
        $slashIndex = max(strrpos($filename, '/'), strrpos($filename, '\\'));
        $dotIndex = strrpos($filename, '.');
        if($dotIndex > $slashIndex) {
            return substr($filename, $dotIndex + 1);
        }
        return '';
    }
}
