<?php
namespace MainBundle\Utils;

class StringUtil
{
    public static $USER_TOKEN_COOKIE_KEY = 'appUserToken';

    public static function startsWith($haystack, $needle, $ignoreCaps = true)
    {
        if ($ignoreCaps) {
            $haystack = strtolower($haystack);
            $needle = strtolower($needle);
        }
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }

    public static function endsWith($haystack, $needle, $ignoreCaps = true)
    {
        if ($ignoreCaps) {
            $haystack = strtolower($haystack);
            $needle = strtolower($needle);
        }
        $length = strlen($needle);
        return $length === 0 || (substr($haystack, -$length) === $needle);
    }

    public static function getFirstSegment($haystack, $seperator)
    {
        $index = strpos($haystack, $seperator);
        if ($index === false) {
            return $haystack;
        }

        return substr($haystack, 0, $index);
    }

    public static function getLastSegment($haystack, $seperator)
    {
        $index = strrpos($haystack, $seperator);
        if ($index === false) {
            return '';
        }

        return substr($haystack, $index + 1);
    }

    public static function removeEnds($haystack, $needle, $ignoreCaps = true)
    {
        $needleLength = strlen($needle);
        while (StringUtil::endsWith($haystack, $needle, $ignoreCaps)) {
            $haystack = substr($haystack, 0, strlen($haystack) - $needleLength);
        }
        return $haystack;
    }

    public static function removeEnd($haystack, $needle, $ignoreCaps = true)
    {
        if (StringUtil::endsWith($haystack, $needle, $ignoreCaps)) {
            $haystack = substr($haystack, 0, strlen($haystack) - strlen($needle));
        }
        return $haystack;
    }

    public static function removeStart($haystack, $needle, $ignoreCaps = true)
    {
        if (StringUtil::startsWith($haystack, $needle, $ignoreCaps)) {
            $haystack = substr($haystack, strlen($needle));
        }
        return $haystack;
    }

    public static function fileName($string)
    {
        // remove html tags
        $clean = strip_tags($string);
        // transliterate
        $clean = transliterator_transliterate('Any-Latin;Latin-ASCII;', $clean);
		// remove non-number and non-letter characters
		$clean = str_replace(array('{','}'), array('[',']'), $clean);
		$clean = preg_replace('/[^a-zA-Z0-9-\_\.\[\]\(\)]/i', '', $clean);

		if(StringUtil::startsWith($clean, '.', false)) {
			$clean = 'file'.$clean;
		}

        return $clean;
    }

    public static function generateRandomString($length)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $maxIndex = strlen($characters) - 1;
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $maxIndex)];
        }
        return $randomString;
    }

    public static function generateRandomLowerString($length) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $maxIndex = strlen($characters) - 1;
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $maxIndex)];
        }
        return $randomString;
    }
}
