<?php

declare(strict_types=1);

namespace PackageVersions;

use OutOfBoundsException;

/**
 * This class is generated by ocramius/package-versions, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 */
final class Versions
{
    public const ROOT_PACKAGE_NAME = 'sgs/server';
    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    public const VERSIONS          = array (
  'aws/aws-sdk-php' => '3.18.23@a2791b6f14b7aa6eeb4fb9f3f779cc291ab455db',
  'aws/aws-sdk-php-symfony' => '2.2.2@dbe2a3a2e202981d27d67396bd6bb291af5d8593',
  'clue/stream-filter' => 'v1.4.1@5a58cc30a8bd6a4eb8f856adf61dd3e013f53f71',
  'doctrine/annotations' => '1.10.3@5db60a4969eba0e0c197a19c077780aadbc43c5d',
  'doctrine/cache' => '1.10.1@35a4a70cd94e09e2259dfae7488afc6b474ecbd3',
  'doctrine/collections' => '1.6.5@fc0206348e17e530d09463fef07ba8968406cd6d',
  'doctrine/common' => '2.13.3@f3812c026e557892c34ef37f6ab808a6b567da7f',
  'doctrine/dbal' => '2.10.2@aab745e7b6b2de3b47019da81e7225e14dcfdac8',
  'doctrine/doctrine-bundle' => '1.12.10@2ee4c25a847e744e93d7fc2895e059ad9ef7d10c',
  'doctrine/doctrine-cache-bundle' => '1.4.0@6bee2f9b339847e8a984427353670bad4e7bdccb',
  'doctrine/event-manager' => '1.1.0@629572819973f13486371cb611386eb17851e85c',
  'doctrine/inflector' => '1.4.3@4650c8b30c753a76bf44fb2ed00117d6f367490c',
  'doctrine/instantiator' => '1.3.1@f350df0268e904597e3bd9c4685c53e0e333feea',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/orm' => 'v2.7.3@d95e03ba660d50d785a9925f41927fef0ee553cf',
  'doctrine/persistence' => '1.3.7@0af483f91bada1c9ded6c2cfd26ab7d5ab2094e0',
  'doctrine/reflection' => '1.2.1@55e71912dfcd824b2fdd16f2d9afe15684cfce79',
  'egulias/email-validator' => '2.1.17@ade6887fd9bd74177769645ab5c474824f8a418a',
  'ekino/wordpress-bundle' => 'dev-master@0d25eac94fbfe28ae5bc7e4fdfbf7a0736187ffd',
  'evenement/evenement' => 'v3.0.1@531bfb9d15f8aa57454f5f0285b18bec903b8fb7',
  'exercise/htmlpurifier-bundle' => 'v3.0@b6c238e9dce45aa8fcb9d1bac3fe3acc0999e489',
  'ezyang/htmlpurifier' => 'v4.12.0@a617e55bc62a87eec73bd456d146d134ad716f03',
  'firebase/php-jwt' => 'v3.0.0@fa8a06e96526eb7c0eeaa47e4f39be59d21f16e1',
  'friendsofsymfony/user-bundle' => 'v2.1.2@1049935edd24ec305cc6cfde1875372fa9600446',
  'google/apiclient' => 'v2.0.0@cd4d61678bc26267f3e5371735ae3f579709ea30',
  'google/apiclient-services' => 'v0.139@84e99f792cae7bd92b8b54c75b0ad3502d628db6',
  'google/auth' => 'v0.8@ec4edcb043e523267973fda308d9412d7db78e17',
  'guzzlehttp/guzzle' => '6.2.0@d094e337976dff9d8e2424e8485872194e768662',
  'guzzlehttp/promises' => 'v1.3.1@a59da6cf61d80060647ff4d3eb2c03a2bc694646',
  'guzzlehttp/psr7' => '1.2.3@2e89629ff057ebb49492ba08e6995d3a6a80021b',
  'hautelook/phpass' => '0.3.0@da4c2c693aa4e1c616a350015c90af0da82a0fd8',
  'hwi/oauth-bundle' => '1.1.0@0131bac13cd889114f47594bb82f7b2927894f50',
  'incenteev/composer-parameter-handler' => 'v2.1.4@084befb11ec21faeadcddefb88b66132775ff59b',
  'james-heinrich/getid3' => 'v1.9.19@c6fd499a690ae67eea2eec6b2edba5df13f60f6f',
  'jdorn/sql-formatter' => 'v1.2.17@64990d96e0959dff8e059dfcdc1af130728d92bc',
  'monolog/monolog' => '1.25.4@3022efff205e2448b560c833c6fbbf91c3139168',
  'mtdowling/jmespath.php' => '2.5.0@52168cb9472de06979613d365c7f1ab8798be895',
  'nikic/php-parser' => 'v4.5.0@53c2753d756f5adb586dca79c2ec0e2654dd9463',
  'nullpunkt/lz-string-php' => 'v1.2.0@b08fc07df528c7e3d05b47e6013dde63eebffb48',
  'nyholm/nsa' => '1.2.0@2606ebf15fb24e15a8ca8d02977ad77082d391ef',
  'ocramius/package-versions' => '1.8.0@421679846270a5772534828013a93be709fb13df',
  'paragonie/random_compat' => 'v2.0.18@0a58ef6e3146256cc3dc7cc393927bcc7d1b72db',
  'phenx/php-font-lib' => '0.5.2@ca6ad461f032145fff5971b5985e5af9e7fa88d8',
  'php-http/client-common' => '2.1.0@a8b29678d61556f45d6236b1667db16d998ceec5',
  'php-http/discovery' => '1.7.4@82dbef649ccffd8e4f22e1953c3a5265992b83c0',
  'php-http/guzzle6-adapter' => 'v2.0.1@6074a4b1f4d5c21061b70bab3b8ad484282fe31f',
  'php-http/httplug' => '2.1.0@72d2b129a48f0490d55b7f89be0d6aa0597ffb06',
  'php-http/httplug-bundle' => '1.18.0@027dff799d50f32cb312f383eb631a035d820db2',
  'php-http/logger-plugin' => '1.1.0@c1c6e90717ce350319b7b8bc489f1db35bb523fd',
  'php-http/message' => '1.8.0@ce8f43ac1e294b54aabf5808515c3554a19c1e1c',
  'php-http/message-factory' => 'v1.0.2@a478cb11f66a6ac48d8954216cfed9aa06a501a1',
  'php-http/promise' => 'v1.0.0@dc494cdc9d7160b9a09bd5573272195242ce7980',
  'php-http/stopwatch-plugin' => '1.3.0@de6f39c96f57c60a43d535e27122de505e683f98',
  'php-translation/common' => '0.3.0@3237ec24b74fcd5310160adfee65f5687a785bae',
  'php-translation/extractor' => '1.7.1@82fc51a07fb626c0bfb31fb3f041baa88fee6acb',
  'php-translation/symfony-bundle' => '0.7.0@9f7ce4ac0c077d8f58753ac0215fb509406e45e8',
  'php-translation/symfony-storage' => '0.5.0@fc1986afd1a1fcc7e71eebe486da490b42ed048d',
  'phpseclib/phpseclib' => '2.0.27@34620af4df7d1988d8f0d7e91f6c8a3bf931d8dc',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.0.0@b7ce3b176482dbbc1245ebf52b181af44c2cf55f',
  'psr/http-client' => '1.0.0@496a823ef742b632934724bf769560c2a5c7c44e',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.3@0f73288fd15629204f9d42b7055f72dacbe811fc',
  'ratchet/pawl' => 'v0.3.4@3a7d5b78e0deaec82f42513a4a3193a8eb12feb1',
  'ratchet/rfc6455' => 'v0.2.6@879e48c840f8dbc296d68d6a5030673df79bd916',
  'react/cache' => 'v1.0.0@aa10d63a1b40a36a486bdf527f28bac607ee6466',
  'react/dns' => 'v1.2.0@a214d90c2884dac18d0cac6176202f247b66d762',
  'react/event-loop' => 'v1.1.1@6d24de090cd59cfc830263cfba965be77b563c13',
  'react/promise' => 'v2.8.0@f3cff96a19736714524ca0dd1d4130de73dbbbc4',
  'react/promise-timer' => 'v1.5.1@35fb910604fd86b00023fc5cda477c8074ad0abc',
  'react/socket' => 'v1.4.0@97522e24987365e1ed873f0f4884900747a668e0',
  'react/stream' => 'v1.1.1@7c02b510ee3f582c810aeccd3a197b9c2f52ff1a',
  'sensio/framework-extra-bundle' => 'v5.5.5@c76bb1c5c67840ecb6d9be8e9d8d7036e375e317',
  'swiftmailer/swiftmailer' => 'v6.2.3@149cfdf118b169f7840bbe3ef0d4bc795d1780c9',
  'symfony/contracts' => 'v1.1.8@f51bca9de06b7a25b19a4155da7bebad099a5def',
  'symfony/monolog-bundle' => 'v3.5.0@dd80460fcfe1fa2050a7103ad818e9d0686ce6fd',
  'symfony/polyfill-apcu' => 'v1.17.0@9ec426b564916afb9bfd15f78708ec322eeb8538',
  'symfony/polyfill-ctype' => 'v1.17.0@e94c8b1bbe2bc77507a1056cdb06451c75b427f9',
  'symfony/polyfill-iconv' => 'v1.17.0@c4de7601eefbf25f9d47190abe07f79fe0a27424',
  'symfony/polyfill-intl-icu' => 'v1.17.0@4ef3923e4a86e1b6ef72d42be59dbf7d33a685e3',
  'symfony/polyfill-intl-idn' => 'v1.17.0@3bff59ea7047e925be6b7f2059d60af31bb46d6a',
  'symfony/polyfill-mbstring' => 'v1.17.0@fa79b11539418b02fc5e1897267673ba2c19419c',
  'symfony/polyfill-php72' => 'v1.17.0@f048e612a3905f34931127360bdd2def19a5e582',
  'symfony/polyfill-php73' => 'v1.17.0@a760d8964ff79ab9bf057613a5808284ec852ccc',
  'symfony/polyfill-php80' => 'v1.17.0@5e30b2799bc1ad68f7feb62b60a73743589438dd',
  'symfony/swiftmailer-bundle' => 'v3.4.0@553d2474288349faed873da8ab7c1551a00d26ae',
  'symfony/symfony' => 'v4.4.10@7eef70427b37763aebfe4ba8aa33e052f91fee3f',
  'thruway/pawl-transport' => '0.5.1@fa297b4aaf74c59fe2fcb41963f55bfcfda70c98',
  'twig/twig' => 'v2.12.5@18772e0190734944277ee97a02a9a6c6555fcd94',
  'webmozart/assert' => '1.8.0@ab2cb0b3b559010b75981b1bdce728da3ee90ad6',
  'symfony/maker-bundle' => 'v1.19.0@bea8c3c959e48a2c952cc7c4f4f32964be8b8874',
  'symfony/phpunit-bridge' => 'v4.4.10@84cb4467ca3ea127f636806e2f6f27c5c1de4eb9',
  'sgs/server' => 'dev-master@35eb808ca3925a64b20038733142f62ca1bf924c',
);

    private function __construct()
    {
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     */
    public static function getVersion(string $packageName) : string
    {
        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
